/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.util.dpkg;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openthinclient.pkgmgr.I18N;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.util.dpkg.PackageReference;
import org.openthinclient.util.dpkg.PackageReferenceList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageReferenceListParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageReferenceListParser.class);
    private static final Pattern SPECIFIER_PATTERN = Pattern.compile("(\\S+)(?:\\s+\\((<<|<|<=|=|>=|>|>>)\\s+(\\S+)\\s*\\))?");

    protected PackageReference parseOrReference(String specifier) {
        String[] segments = specifier.split("\\s*\\|\\s*");
        ArrayList<PackageReference.SingleReference> references = new ArrayList<PackageReference.SingleReference>(segments.length);
        for (String segment : segments) {
            references.add(this.parseSingle(segment));
        }
        return new PackageReference.OrReference(references);
    }

    public PackageReferenceList parse(String specifier) {
        String[] segments;
        if (Strings.isNullOrEmpty((String)specifier)) {
            return new PackageReferenceList();
        }
        PackageReferenceList result = new PackageReferenceList();
        for (String segment : segments = specifier.split("\\s*,\\s*")) {
            if (segment.contains("|")) {
                result.add(this.parseOrReference(segment));
                continue;
            }
            result.add(this.parseSingle(segment));
        }
        return result;
    }

    protected PackageReference.SingleReference parseSingle(String specifier) {
        Version version;
        PackageReference.Relation relation;
        String name;
        try {
            specifier = specifier.trim();
            Matcher m = SPECIFIER_PATTERN.matcher(specifier);
            if (!m.matches()) {
                LOGGER.error("Illegal specifier pattern '" + specifier + "' in Packages, allowed: " + SPECIFIER_PATTERN);
                throw new IllegalArgumentException(I18N.getMessage("PackageReference.IllegalArgument") + ": " + specifier);
            }
            name = m.group(1);
            if (m.group(2) != null) {
                relation = PackageReference.Relation.getByTextualRepresentation(m.group(2));
                version = Version.parse(m.group(3));
            } else {
                version = null;
                relation = null;
            }
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(I18N.getMessage("PackageReference.IllegalArgument") + ": ", e);
        }
        return new PackageReference.SingleReference(name, relation, version);
    }
}

