/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.syslogd;

import java.net.InetAddress;
import java.net.SocketException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.openthinclient.syslogd.SyslogDaemon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Log4JSyslogDaemon
extends SyslogDaemon {
    private static final Logger logger = LoggerFactory.getLogger(Log4JSyslogDaemon.class);
    private Map<SyslogDaemon.Facility, Logger> loggerMap = new HashMap<SyslogDaemon.Facility, Logger>();
    private final String prefix;

    public Log4JSyslogDaemon() throws SocketException {
        this.prefix = "syslog";
    }

    public Log4JSyslogDaemon(int port) throws SocketException {
        this(port, "syslog");
    }

    public Log4JSyslogDaemon(int port, String prefix) throws SocketException {
        super(port);
        this.prefix = prefix;
    }

    @Override
    protected void handleMessage(InetAddress source, String hostname, SyslogDaemon.Priority prio, SyslogDaemon.Facility facility, Date timestamp, String message) {
        MDC.put((String)"hostname", (String)(hostname != null ? hostname : "-"));
        MDC.put((String)"peer", (String)(null != source ? source.getHostAddress() : "-"));
        Logger eventLogger = LoggerFactory.getLogger((String)"EventLogger");
        switch (prio) {
            case LOG_ERR: {
                eventLogger.error(facility.getFullName() + " " + message);
                break;
            }
            case LOG_DEBUG: {
                eventLogger.debug(facility.getFullName() + " " + message);
                break;
            }
            case LOG_WARNING: {
                eventLogger.warn(facility.getFullName() + " " + message);
                break;
            }
            default: {
                eventLogger.info(facility.getFullName() + " " + message);
            }
        }
    }

    @Override
    protected void handleError(String message, Throwable t) {
        logger.error(message, t);
    }
}

