/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.tftp.tftpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import org.openthinclient.tftp.tftpd.TFTPProvider;

public class FilesystemProvider
implements TFTPProvider {
    private final String basedir;

    public FilesystemProvider(String basedir) {
        this.basedir = basedir;
    }

    @Override
    public long getLength(SocketAddress peer, SocketAddress local, String prefix, String filename) throws IOException {
        File file = new File(this.basedir, filename);
        if (file.exists() && file.isFile() && file.canRead()) {
            return file.length();
        }
        throw new FileNotFoundException(file.getPath());
    }

    @Override
    public InputStream getStream(SocketAddress peer, SocketAddress local, String prefix, String filename) throws IOException {
        File file = new File(this.basedir, filename);
        if (file.exists() && file.isFile() && file.canRead()) {
            return new FileInputStream(file);
        }
        throw new FileNotFoundException(file.getPath());
    }
}

