/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.tftp.tftpd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.openthinclient.tftp.tftpd.TFTPExport;
import org.openthinclient.tftp.tftpd.TFTPProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TFTPServer
implements Runnable {
    public static final short DEFAULT_TFTP_PORT = 69;
    private static final Logger logger = LoggerFactory.getLogger(TFTPServer.class);
    private static final short READ = 1;
    private static final short WRITE = 2;
    private static final short DATA = 3;
    private static final short ACK = 4;
    private static final short ERROR = 5;
    private static final short OACK = 6;
    private static final short ERROR_UNDEFINED = 0;
    private static final short ERROR_FILE_NOT_FOUND = 1;
    private static final short ERROR_ACCESS_VIOLATION = 2;
    private static final short ERROR_ILLEGAL_OPERATION = 4;
    private static final int RECV_TIMEOUT = 2000;
    private static final int MAX_RETRIES = 5;
    private static final int STD_TFTP_MAX_PACKET_LENGTH = 516;
    private static final int MAX_ERRORS_IN_ONE_SECOND = 100;
    private static final boolean PROVIDE_LOCAL_ADDRESS = true;
    private final Collection<DatagramChannel> openDatagramChannels = new ArrayList<DatagramChannel>();
    private final Set<TFTPExport> exports = new HashSet<TFTPExport>();
    private final Selector serverSelector = Selector.open();

    public TFTPServer(int port) throws IOException {
        Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
        while (i.hasMoreElements()) {
            NetworkInterface nif = i.nextElement();
            Enumeration<InetAddress> j = nif.getInetAddresses();
            while (j.hasMoreElements()) {
                InetAddress address = j.nextElement();
                if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                this.configureChannel(new InetSocketAddress(address, port));
            }
        }
    }

    private static String getCString(ByteBuffer b) {
        int start = b.position();
        while (b.hasRemaining() && b.get() != 0) {
        }
        if (b.position() == start || b.get(b.position() - 1) != 0) {
            return null;
        }
        byte[] s = new byte[b.position() - 1 - start];
        b.position(start);
        b.get(s);
        b.get();
        try {
            return new String(s, "ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Should not happen");
        }
    }

    private static void sendErrorPacket(SocketAddress peer, DatagramChannel channel, short code, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug("Sending error packet to " + peer + ": " + code + "/" + message);
        }
        try {
            byte[] messageBytes = message.getBytes("ASCII");
            ByteBuffer b = ByteBuffer.allocate(5 + messageBytes.length);
            b.putShort((short)5);
            b.putShort(code);
            b.put(messageBytes);
            b.put((byte)0);
            b.flip();
            channel.send(b, peer);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("that's ridiculous", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Exception sending error packet to " + peer, (Throwable)e);
        }
    }

    private void configureChannel(InetSocketAddress isa) throws IOException {
        DatagramChannel serverChannel = DatagramChannel.open();
        if (serverChannel.socket().isBound()) {
            serverChannel.socket().setReuseAddress(true);
        }
        serverChannel.socket().bind(isa);
        serverChannel.socket().setReceiveBufferSize(2580);
        serverChannel.socket().setSendBufferSize(2580);
        serverChannel.configureBlocking(false);
        serverChannel.register(this.serverSelector, 1);
        this.openDatagramChannels.add(serverChannel);
        logger.info("Listening on " + isa);
    }

    public void start() {
        new Thread((Runnable)this, "TFTP Server").start();
    }

    public void shutdown() {
        logger.info("Shutting down TFTP server.");
        try {
            for (DatagramChannel d : this.openDatagramChannels) {
                d.close();
            }
            this.serverSelector.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        long lastSecond = System.currentTimeMillis() / 1000L;
        int errorCounter = 0;
        ByteBuffer buffer = ByteBuffer.allocate(516);
        block10: while (true) {
            long second;
            if ((second = System.currentTimeMillis() / 1000L) != lastSecond) {
                errorCounter = 0;
            }
            try {
                int n = this.serverSelector.select();
                if (0 == n) continue;
                Iterator<SelectionKey> i = this.serverSelector.selectedKeys().iterator();
                block11: while (true) {
                    if (!i.hasNext()) continue block10;
                    SelectionKey key = i.next();
                    i.remove();
                    DatagramChannel serverChannel = (DatagramChannel)key.channel();
                    buffer.clear();
                    SocketAddress peer = serverChannel.receive(buffer);
                    buffer.flip();
                    if (buffer.limit() <= 2) {
                        TFTPServer.sendErrorPacket(peer, serverChannel, (short)0, "Short packet");
                        continue;
                    }
                    switch (buffer.getShort()) {
                        case 1: {
                            this.handleREAD(buffer, peer, serverChannel);
                            continue block11;
                        }
                        case 2: {
                            TFTPServer.sendErrorPacket(peer, serverChannel, (short)2, "WRITE not supported");
                            logger.warn("WRITE not supported");
                            continue block11;
                        }
                        case 5: {
                            logger.warn("Got ERROR " + this.parseERRORPacket(buffer));
                            continue block11;
                        }
                        case 4: {
                            continue block11;
                        }
                    }
                    logger.warn("Illegal operation " + buffer.getShort(0) + " requested.");
                    TFTPServer.sendErrorPacket(peer, serverChannel, (short)4, "Operation not supported");
                }
            }
            catch (ClosedSelectorException e) {
                logger.debug("Selector closed, shutting down.");
                return;
            }
            catch (AsynchronousCloseException e) {
                logger.debug("Channel closed, shutting down.");
                return;
            }
            catch (Throwable e) {
                if (++errorCounter > 100) {
                    logger.error("Shutting down due to repeated errors (" + errorCounter + " within the last second).");
                    return;
                }
                logger.error("Caught throwable in main loop. Trying to hang on anyway. (" + errorCounter + " errors within this second already)", e);
                continue;
            }
            break;
        }
    }

    private void handleREAD(ByteBuffer buffer, SocketAddress peer, DatagramChannel serverChannel) throws IOException {
        try {
            new TFTPSend(peer, buffer, serverChannel).start();
        }
        catch (IOException e) {
            logger.error("READ: error starting transfer for " + peer, (Throwable)e);
            TFTPServer.sendErrorPacket(peer, serverChannel, (short)0, e.toString());
        }
    }

    private String parseERRORPacket(ByteBuffer buffer) throws UnsupportedEncodingException {
        buffer.position(2);
        String message = buffer.getShort() + ": " + TFTPServer.getCString(buffer);
        return message;
    }

    public void addExport(TFTPExport export) {
        this.exports.add(export);
    }

    public boolean removeExport(TFTPExport export) {
        return this.exports.remove(export);
    }

    public Set<TFTPExport> getExports() {
        return Collections.unmodifiableSet(this.exports);
    }

    private class TFTPSend
    extends Thread {
        private final SocketAddress peer;
        private final DatagramChannel serverChannel;
        protected InputStream source;
        private DatagramChannel channel;
        private int timeout;
        private HashMap<String, String> options;
        private Selector selector;
        private int blksize;
        private String filename;
        private String modestring;

        public TFTPSend(SocketAddress peer, ByteBuffer buffer, DatagramChannel serverChannel) throws IOException {
            super("TFTP Send for " + peer);
            this.timeout = 2000;
            this.blksize = 512;
            this.peer = peer;
            this.serverChannel = serverChannel;
            this.parseRequest(peer, buffer, serverChannel);
        }

        private void parseRequest(SocketAddress peer, ByteBuffer buffer, DatagramChannel serverChannel) throws IOException {
            buffer.position(2);
            this.filename = TFTPServer.getCString(buffer);
            this.modestring = TFTPServer.getCString(buffer);
            if (null == this.filename || null == this.modestring) {
                throw new IOException("Malformed request");
            }
            if (!this.modestring.equalsIgnoreCase("octet")) {
                throw new IOException("Transfer mode \"" + this.modestring + "\" not supported");
            }
            if (this.filename.matches(".*\\.\\.[/\\\\].*")) {
                throw new FileNotFoundException("No relative filename hacks, please (nice try, though).");
            }
            this.options = new HashMap();
            while (true) {
                String option = TFTPServer.getCString(buffer);
                String value = TFTPServer.getCString(buffer);
                if (null == option || null == value) break;
                this.options.put(option.toLowerCase(), value);
            }
        }

        private void initTransfer(SocketAddress peer, DatagramChannel serverChannel) throws IOException, InstantiationException, IllegalAccessException {
            this.channel = DatagramChannel.open();
            this.channel.socket().bind(new InetSocketAddress(0));
            this.selector = Selector.open();
            this.channel.configureBlocking(false);
            this.channel.register(this.selector, 1);
            TFTPServer.this.openDatagramChannels.add(this.channel);
            if (!this.filename.startsWith("/")) {
                this.filename = "/" + this.filename;
            }
            TFTPExport bestMatch = this.findExport(this.filename);
            TFTPProvider provider = bestMatch.getProvider();
            String prefix = bestMatch.getPathPrefix();
            String localName = this.filename.substring(bestMatch.getPathPrefix().length());
            this.source = provider.getStream(peer, serverChannel.socket().getLocalSocketAddress(), prefix, localName);
            logger.info("Starting TFTP send for " + this.filename + " to " + peer);
            HashMap<String, String> recognizedOptions = new HashMap<String, String>();
            if (this.options.containsKey("timeout")) {
                try {
                    this.timeout = Integer.parseInt(this.options.get("timeout")) * 1000;
                    recognizedOptions.put("timeout", Integer.toString(this.timeout / 1000));
                }
                catch (NumberFormatException e) {
                    logger.error("Got invalid timeout option argument: " + this.options.get("timeout"), (Throwable)e);
                }
            }
            if (this.options.containsKey("tsize")) {
                long len = provider.getLength(peer, serverChannel.socket().getLocalSocketAddress(), prefix, localName);
                if (len < 0L) {
                    len = this.getDataLength();
                }
                recognizedOptions.put("tsize", Long.toString(len));
            }
            if (this.options.containsKey("blksize")) {
                try {
                    this.blksize = Integer.parseInt(this.options.get("blksize"));
                    if (this.blksize < 10 || this.blksize > 65535) {
                        throw new IOException("Illegal blksize option: " + this.blksize);
                    }
                    recognizedOptions.put("blksize", Integer.toString(this.blksize));
                    if (logger.isInfoEnabled()) {
                        logger.info("Using blksize=" + this.blksize);
                    }
                }
                catch (NumberFormatException e) {
                    throw new IOException("Got invalid blksize option argument: " + this.options.get("blksize"));
                }
            }
            if (recognizedOptions.size() > 0) {
                ByteBuffer buffer1 = ByteBuffer.allocate(516);
                buffer1.clear();
                buffer1.putShort((short)6);
                for (Map.Entry e : recognizedOptions.entrySet()) {
                    buffer1.put(((String)e.getKey()).getBytes("ASCII"));
                    buffer1.put((byte)0);
                    buffer1.put(((String)e.getValue()).getBytes("ASCII"));
                    buffer1.put((byte)0);
                }
                buffer1.flip();
                if (logger.isDebugEnabled()) {
                    logger.debug("Sending OACK with options " + recognizedOptions);
                }
                this.sendAndWaitForACK(buffer1, ByteBuffer.allocate(516), (short)0);
            }
            this.setName("TFTP Send for " + peer + " file: " + this.filename);
        }

        private TFTPExport findExport(String filename) throws FileNotFoundException {
            TFTPExport bestMatch = null;
            logger.debug("Searching for Export: {}", (Object)filename);
            for (TFTPExport export : TFTPServer.this.exports) {
                if (!filename.startsWith(export.getPathPrefix()) || bestMatch != null && export.getPathPrefix().length() <= bestMatch.getPathPrefix().length()) continue;
                bestMatch = export;
                logger.debug("Found matching Export: {} -> {}", (Object)filename, (Object)export);
            }
            if (null == bestMatch) {
                throw new FileNotFoundException(filename);
            }
            return bestMatch;
        }

        private long getDataLength() throws IOException {
            int read;
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((read = this.source.read(b)) >= 0) {
                s.write(b, 0, read);
            }
            this.source.close();
            b = s.toByteArray();
            long len = b.length;
            this.source = new ByteArrayInputStream(b);
            return len;
        }

        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                this.initTransfer(this.peer, this.serverChannel);
                logger.info("TFTP startup took " + (System.currentTimeMillis() - start));
                try {
                    int bytesInBuffer;
                    ByteBuffer xmitBuffer = ByteBuffer.allocate(this.blksize + 4);
                    ByteBuffer recvBuffer = ByteBuffer.allocate(this.blksize + 4);
                    short block = 1;
                    byte[] inBuffer = new byte[this.blksize];
                    do {
                        int read;
                        xmitBuffer.clear();
                        xmitBuffer.putShort((short)3);
                        xmitBuffer.putShort(block);
                        for (bytesInBuffer = 0; (read = this.source.read(inBuffer, bytesInBuffer, inBuffer.length - bytesInBuffer)) >= 0 && bytesInBuffer < inBuffer.length; bytesInBuffer += read) {
                        }
                        xmitBuffer.put(inBuffer, 0, bytesInBuffer);
                        xmitBuffer.flip();
                        this.sendAndWaitForACK(xmitBuffer, recvBuffer, block);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sent DATA: block=" + block + " length=" + bytesInBuffer);
                        }
                        block = (short)(block + 1);
                    } while (bytesInBuffer == this.blksize);
                    logger.info("TFTP send to " + this.peer + " finished normally.");
                }
                catch (IOException e) {
                    logger.info("TFTP send to " + this.peer + " failed.", (Throwable)e);
                    TFTPServer.sendErrorPacket(this.peer, this.channel, (short)0, e.toString());
                }
            }
            catch (FileNotFoundException e) {
                String message = e.getMessage();
                int idx = message.indexOf(": ");
                if (idx > 0) {
                    message = message.substring(idx + 2);
                }
                logger.error("READ: file not found for " + this.peer + ": " + message);
                TFTPServer.sendErrorPacket(this.peer, this.serverChannel, (short)1, message);
            }
            catch (IOException e) {
                logger.error("READ: error starting transfer for " + this.peer + ": " + e.getMessage());
                TFTPServer.sendErrorPacket(this.peer, this.serverChannel, (short)1, e.toString());
            }
            catch (Throwable e) {
                logger.error("READ: error starting transfer for " + this.peer, e);
                TFTPServer.sendErrorPacket(this.peer, this.serverChannel, (short)0, e.toString());
            }
            try {
                if (null != this.channel) {
                    this.channel.close();
                }
            }
            catch (IOException e) {
                logger.error("Error closing channel", (Throwable)e);
            }
            try {
                if (null != this.selector) {
                    this.selector.close();
                }
            }
            catch (IOException e) {
                logger.error("Error closing selector", (Throwable)e);
            }
        }

        private void sendAndWaitForACK(ByteBuffer xmitBuffer, ByteBuffer recvBuffer, short block) throws IOException {
            int xmitTrys = 0;
            boolean gotACK = false;
            while (!gotACK) {
                this.channel.send(xmitBuffer, this.peer);
                xmitBuffer.rewind();
                gotACK = this.waitForACK(recvBuffer, block);
                if (gotACK || ++xmitTrys < 5) continue;
                throw new IOException("Failed to transfer file: retries exceeded.");
            }
        }

        private boolean waitForACK(ByteBuffer recvBuffer, short block) throws IOException {
            while (true) {
                this.selector.selectedKeys().clear();
                int ready = this.selector.select(this.timeout);
                if (ready == 0) {
                    logger.debug("ACK receive timeout");
                    return false;
                }
                recvBuffer.clear();
                SocketAddress sender = this.channel.receive(recvBuffer);
                recvBuffer.flip();
                if (null == sender || !sender.equals(this.peer)) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignoring packet from host != my peer: " + sender);
                    continue;
                }
                if (recvBuffer.getShort(0) != 4) {
                    if (recvBuffer.getShort(0) == 5) {
                        String message = TFTPServer.this.parseERRORPacket(recvBuffer);
                        throw new IOException("Error received: " + message);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Ignoring packet with opcode " + recvBuffer.getShort(0));
                    continue;
                }
                if (recvBuffer.getShort(2) == block) break;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Ignoring packet with wrong block# " + recvBuffer.getShort(2));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Got ACK: block=" + recvBuffer.getShort(2));
            }
            return true;
        }
    }
}

