/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.service.update.UpdateDescriptor;

public class AvailableVersionChecker {
    private final DownloadManager downloadManager;

    public AvailableVersionChecker(DownloadManager downloadManager) {
        this.downloadManager = downloadManager;
    }

    public UpdateDescriptor getVersion(URI uri, ProgressReceiver progressReceiver) throws JAXBException, IOException {
        if (this.requiresHttpDownload(uri)) {
            return (UpdateDescriptor)this.downloadManager.download(uri, in -> this.read(in), progressReceiver);
        }
        try (InputStream in2 = uri.toURL().openStream();){
            UpdateDescriptor updateDescriptor = this.read(in2);
            return updateDescriptor;
        }
    }

    private UpdateDescriptor read(InputStream in) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{UpdateDescriptor.class});
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        return (UpdateDescriptor)jaxbUnmarshaller.unmarshal(in);
    }

    public boolean requiresHttpDownload(URI uri) {
        return uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https");
    }
}

