/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientGroupService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.sysreport.StatisticsReport;
import org.openthinclient.sysreport.generate.ReportContributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationSummaryReportContributor
implements ReportContributor<StatisticsReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationSummaryReportContributor.class);
    private final ClientService clientService;
    private final UnrecognizedClientService unrecognizedClientService;
    private final ApplicationService applicationService;
    private final ApplicationGroupService applicationGroupService;
    private final ClientGroupService clientGroupService;
    private final RealmService realmService;
    private final UserService userService;
    private final UserGroupService userGroupService;
    private final DeviceService deviceService;
    private final LocationService locationService;
    private final PrinterService printerService;
    private final HardwareTypeService hardwareTypeService;
    private final LicenseManager licenseManager;
    private final ManagerHome managerHome;

    public ConfigurationSummaryReportContributor(ManagerHome managerHome, LicenseManager licenseManager, ClientService clientService, UnrecognizedClientService unrecognizedClientService, ClientGroupService clientGroupService, ApplicationService applicationService, ApplicationGroupService applicationGroupService, RealmService realmService, UserService userService, UserGroupService userGroupService, DeviceService deviceService, LocationService locationService, PrinterService printerService, HardwareTypeService hardwareTypeService) {
        this.clientService = clientService;
        this.unrecognizedClientService = unrecognizedClientService;
        this.applicationService = applicationService;
        this.applicationGroupService = applicationGroupService;
        this.clientGroupService = clientGroupService;
        this.realmService = realmService;
        this.userService = userService;
        this.userGroupService = userGroupService;
        this.deviceService = deviceService;
        this.locationService = locationService;
        this.printerService = printerService;
        this.hardwareTypeService = hardwareTypeService;
        this.licenseManager = licenseManager;
        this.managerHome = managerHome;
    }

    @Override
    public void contribute(StatisticsReport report) {
        report.getConfiguration().setThinClientCount(this.clientService.count());
        report.getConfiguration().setUnrecognizedClientCount(this.unrecognizedClientService.count());
        Set clients = this.clientService.findAll();
        report.getConfiguration().setThinClientCount(clients.size());
        Set applicationGroups = this.applicationGroupService.findAll();
        report.getConfiguration().setApplicationGroupCount(applicationGroups.size());
        report.getConfiguration().setThinClientGroupCount(this.clientGroupService.findAll().size());
        Set applications = this.applicationService.findAll();
        report.getConfiguration().setApplications(this.countTypes(applications));
        ClientMap appClients = this.getCollectClientsByProfile(clients, Client::getApplications);
        for (ApplicationGroup applicationGroup : applicationGroups) {
            for (Application groupedApplication : applicationGroup.getApplications()) {
                Set applicationGroupClients = applicationGroup.getMembers().stream().filter(Objects::nonNull).filter(o -> o instanceof Client).collect(Collectors.toSet());
                appClients.get(groupedApplication).addAll(applicationGroupClients);
            }
        }
        report.getConfiguration().setApplicationTypeUsage(this.countSchemaObjects(applications, appClients));
        Set hardwareTypes = this.hardwareTypeService.findAll();
        report.getConfiguration().setHardwaretypes(hardwareTypes.size());
        HashSet<HardwareType> usedHardwareTypes = new HashSet<HardwareType>();
        for (Client client2 : clients) {
            usedHardwareTypes.add(client2.getHardwareType());
        }
        report.getConfiguration().setHardwaretypeUsage(usedHardwareTypes.size());
        ClientMap hwtClients = this.getCollectClientsByProfile(clients, Client::getHwTypes);
        Set devices = this.deviceService.findAll();
        report.getConfiguration().setDevices(this.countTypes(devices));
        ClientMap deviceClients = this.getCollectClientsByProfile(clients, Client::getDevices);
        for (HardwareType hardwaretype : hardwareTypes) {
            for (Device device : hardwaretype.getDevices()) {
                deviceClients.get(device).addAll(hwtClients.get(hardwaretype));
            }
        }
        report.getConfiguration().setDeviceTypeUsage(this.countSchemaObjects(devices, deviceClients));
        Set locations = this.locationService.findAll();
        report.getConfiguration().setLocations(locations.size());
        HashSet<Location> usedLocations = new HashSet<Location>();
        for (Client client3 : clients) {
            usedLocations.add(client3.getLocation());
        }
        report.getConfiguration().setLocationUsage(usedLocations.size());
        ClientMap locationClients = this.getCollectClientsByProfile(clients, client -> Stream.of(client.getLocation()).collect(Collectors.toSet()));
        Set printers = this.printerService.findAll();
        report.getConfiguration().setPrinters(this.countTypes(printers));
        ClientMap printerClients = this.getCollectClientsByProfile(clients, Client::getPrinters);
        for (Location location : locations) {
            for (Printer printer : location.getPrinters()) {
                if (printerClients.containsKey(printer)) {
                    ((Set)printerClients.get(printer)).addAll((Collection)locationClients.get(location));
                    continue;
                }
                printerClients.put(printer, locationClients.get(location));
            }
        }
        report.getConfiguration().setPrinterUsage(this.countSchemaObjects(printers, printerClients));
        String secondaryLdapUrl = this.realmService.getDefaultRealm().getValue("Directory.Secondary.LDAPURLs");
        String version = this.realmService.getDefaultRealm().getValue("UserGroupSettings.DirectoryVersion");
        boolean secondaryLdapActive = version != null && version.equals("secondary") && secondaryLdapUrl != null && secondaryLdapUrl.length() > 0;
        report.getConfiguration().setSecondaryLdapActive(secondaryLdapActive);
        if (!secondaryLdapActive) {
            report.getConfiguration().setPrimaryLdapUserCount(this.userService.count());
            report.getConfiguration().setPrimaryLdapUserGroupCount(this.userGroupService.count());
        }
        report.getConfiguration().setLicenseState(this.licenseManager.getLicenseState(clients.size()).name());
        License license = this.licenseManager.getLicense();
        if (license != null) {
            report.getConfiguration().setLicenseCount(license.getCount());
            report.getConfiguration().setLicenseSoftExpiredDate(license.getSoftExpiredDate());
            report.getConfiguration().setLicenseExpiredDate(license.getExpiredDate());
        }
    }

    protected <T extends Profile> ClientMap<T> getCollectClientsByProfile(Set<Client> clients, Function<Client, Set<T>> function) {
        ClientMap profileClients = new ClientMap();
        for (Client client : clients) {
            for (Profile profile : function.apply(client)) {
                if (profile == null) continue;
                profileClients.get(profile).add(client);
            }
        }
        return profileClients;
    }

    protected <T extends Profile> Map<String, Long> countSchemaObjects(Set<T> allProfiles, Map<T, Set<Client>> clients) {
        HashMap<String, Set> schemaTCcount = new HashMap<String, Set>();
        for (Map.Entry ac : clients.entrySet()) {
            this.getProfileWithRealm(allProfiles, (Profile)ac.getKey()).ifPresent(profile -> {
                String schemaName = "";
                try {
                    schemaName = profile.getSchema(profile.getRealm()).getName();
                }
                catch (Exception e) {
                    LOGGER.warn("Cannot create statistics for profile " + profile.getName() + ", reason: " + e.getMessage());
                }
                schemaTCcount.compute(schemaName, (k, v) -> v == null ? (Set)ac.getValue() : Stream.concat(v.stream(), ((Set)ac.getValue()).stream()).collect(Collectors.toSet()));
            });
        }
        HashMap objectsCounts = new HashMap();
        schemaTCcount.forEach((s, c) -> objectsCounts.put(s, Long.valueOf(c.size())));
        return new TreeMap<String, Long>(objectsCounts);
    }

    protected <T extends Profile> Optional<T> getProfileWithRealm(Set<T> allProfiles, T capp) {
        if (allProfiles == null || capp == null || capp.getDn() == null) {
            return Optional.empty();
        }
        return allProfiles.stream().filter(profile -> profile.getDn() != null ? profile.getDn().equals(capp.getDn()) : profile.getName().equals(capp.getName())).findFirst();
    }

    private <T extends Profile> Map<String, Long> countTypes(Set<T> objects) {
        Map<String, Long> typeCounts = objects.stream().map(profile -> {
            try {
                return profile.getSchema(profile.getRealm());
            }
            catch (Exception e) {
                LOGGER.warn("Cannot create statistics for profile " + profile.getName() + ", reason: " + e.getMessage());
                return null;
            }
        }).filter(Objects::nonNull).map(Node::getName).collect(Collectors.groupingBy(k -> k, Collectors.counting()));
        return new TreeMap<String, Long>(typeCounts);
    }

    private class ClientMap<T>
    extends HashMap<T, Set<Client>> {
        private ClientMap() {
        }

        @Override
        public Set<Client> get(Object key) {
            HashSet clientSet = (HashSet)super.get(key);
            if (clientSet == null) {
                clientSet = new HashSet();
                this.put(key, clientSet);
            }
            return clientSet;
        }
    }
}

