/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openthinclient.sysreport.AbstractReport;
import org.openthinclient.sysreport.Source;

@JsonPropertyOrder(value={"report-version"})
public class StatisticsReport
extends AbstractReport {
    @JsonProperty(value="report-version")
    private final int reportVersion = 1;
    @JsonProperty(value="created")
    private Long created = OffsetDateTime.now(ZoneOffset.UTC).toEpochSecond();
    private final Network network = new Network();
    @JsonProperty(value="package-manager")
    private final PackageManagerSummary packageManager = new PackageManagerSummary();
    @JsonProperty(value="configuration")
    private final ConfigurationSummary configuration = new ConfigurationSummary();

    public ConfigurationSummary getConfiguration() {
        return this.configuration;
    }

    public PackageManagerSummary getPackageManager() {
        return this.packageManager;
    }

    public Network getNetwork() {
        return this.network;
    }

    public static class ConfigurationSummary {
        @JsonProperty(value="thinclient-count")
        private int thinClientCount;
        @JsonProperty(value="unregistered-count")
        private int unrecognizedClientCount;
        @JsonProperty(value="application-group-count")
        private int applicationGroupCount;
        @JsonProperty(value="thinclient-group-count")
        private int thinClientGroupCount;
        @JsonProperty(value="secondary-ldap-active")
        private boolean secondaryLdapActive;
        @JsonProperty(value="primary-ldap-user-count")
        private Integer primaryLdapUserCount;
        @JsonProperty(value="primary-ldap-user-group-count")
        private Integer primaryLdapUserGroupCount;
        @JsonProperty
        private Map<String, Long> applications = new TreeMap<String, Long>();
        @JsonProperty
        private Map<String, Long> applicationTypeUsage = new TreeMap<String, Long>();
        @JsonProperty
        private Map<String, Long> devices = new TreeMap<String, Long>();
        @JsonProperty
        private Map<String, Long> deviceTypeUsage = new TreeMap<String, Long>();
        @JsonProperty
        private Integer locations;
        @JsonProperty
        private Integer locationUsage;
        @JsonProperty
        private Map<String, Long> printers = new TreeMap<String, Long>();
        @JsonProperty
        private Map<String, Long> printerUsage = new TreeMap<String, Long>();
        @JsonProperty
        private Integer hardwaretypes;
        @JsonProperty
        private Integer hardwaretypeUsage;
        @JsonProperty
        Integer licenseCount;
        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        LocalDate licenseSoftExpiredDate;
        @JsonProperty
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
        LocalDate licenseExpiredDate;
        @JsonProperty
        String licenseState;

        public int getApplicationGroupCount() {
            return this.applicationGroupCount;
        }

        public void setApplicationGroupCount(int applicationGroupCount) {
            this.applicationGroupCount = applicationGroupCount;
        }

        public int getThinClientGroupCount() {
            return this.thinClientGroupCount;
        }

        public void setThinClientGroupCount(int thinClientGroupCount) {
            this.thinClientGroupCount = thinClientGroupCount;
        }

        public int getUnrecognizedClientCount() {
            return this.unrecognizedClientCount;
        }

        public void setUnrecognizedClientCount(int unrecognizedClientCount) {
            this.unrecognizedClientCount = unrecognizedClientCount;
        }

        public int getThinClientCount() {
            return this.thinClientCount;
        }

        public void setThinClientCount(int thinClientCount) {
            this.thinClientCount = thinClientCount;
        }

        public boolean isSecondaryLdapActive() {
            return this.secondaryLdapActive;
        }

        public void setSecondaryLdapActive(boolean secondaryLdapActive) {
            this.secondaryLdapActive = secondaryLdapActive;
        }

        public Map<String, Long> getApplications() {
            return this.applications;
        }

        public void setApplications(Map<String, Long> applications) {
            this.applications = applications;
        }

        public Integer getPrimaryLdapUserCount() {
            return this.primaryLdapUserCount;
        }

        public void setPrimaryLdapUserCount(Integer primaryLdapUserCount) {
            this.primaryLdapUserCount = primaryLdapUserCount;
        }

        public Integer getPrimaryLdapUserGroupCount() {
            return this.primaryLdapUserGroupCount;
        }

        public void setPrimaryLdapUserGroupCount(Integer primaryLdapUserGroupCount) {
            this.primaryLdapUserGroupCount = primaryLdapUserGroupCount;
        }

        public Map<String, Long> getApplicationTypeUsage() {
            return this.applicationTypeUsage;
        }

        public void setApplicationTypeUsage(Map<String, Long> applicationTypeUsage) {
            this.applicationTypeUsage = applicationTypeUsage;
        }

        public Map<String, Long> getDeviceTypeUsage() {
            return this.deviceTypeUsage;
        }

        public Integer getLocationUsage() {
            return this.locationUsage;
        }

        public void setLocationUsage(int locationUsage) {
            this.locationUsage = locationUsage;
        }

        public Map<String, Long> getPrinterUsage() {
            return this.printerUsage;
        }

        public void setPrinterUsage(Map<String, Long> printerUsage) {
            this.printerUsage = printerUsage;
        }

        public void setDeviceTypeUsage(Map<String, Long> deviceTypeUsage) {
            this.deviceTypeUsage = deviceTypeUsage;
        }

        public Integer getHardwaretypeUsage() {
            return this.hardwaretypeUsage;
        }

        public void setHardwaretypeUsage(int hardwaretypeUsage) {
            this.hardwaretypeUsage = hardwaretypeUsage;
        }

        public Map<String, Long> getDevices() {
            return this.devices;
        }

        public void setDevices(Map<String, Long> devices) {
            this.devices = devices;
        }

        public Integer getLocations() {
            return this.locations;
        }

        public void setLocations(int locations) {
            this.locations = locations;
        }

        public Map<String, Long> getPrinters() {
            return this.printers;
        }

        public void setPrinters(Map<String, Long> printers) {
            this.printers = printers;
        }

        public Integer getHardwaretypes() {
            return this.hardwaretypes;
        }

        public void setHardwaretypes(int hardwaretypes) {
            this.hardwaretypes = hardwaretypes;
        }

        public Integer getLicenseCount() {
            return this.licenseCount;
        }

        public void setLicenseCount(Integer licenseCount) {
            this.licenseCount = licenseCount;
        }

        public LocalDate getLicenseSoftExpiredDate() {
            return this.licenseSoftExpiredDate;
        }

        public void setLicenseSoftExpiredDate(LocalDate licenseSoftExpiredDate) {
            this.licenseSoftExpiredDate = licenseSoftExpiredDate;
        }

        public LocalDate getLicenseExpiredDate() {
            return this.licenseExpiredDate;
        }

        public void setLicenseExpiredDate(LocalDate licenseExpiredDate) {
            this.licenseExpiredDate = licenseExpiredDate;
        }

        public String getLicenseState() {
            return this.licenseState;
        }

        public void setLicenseState(String licenseState) {
            this.licenseState = licenseState;
        }
    }

    public static class PackageSummary {
        private final String name;
        private final String version;

        public PackageSummary(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class PackageManagerSummary {
        private final List<PackageSummary> installed = new ArrayList<PackageSummary>();
        private final List<Source> sources = new ArrayList<Source>();

        public List<PackageSummary> getInstalled() {
            return this.installed;
        }

        public List<Source> getSources() {
            return this.sources;
        }
    }

    public static class Network {
        private final List<AbstractReport.NetworkInterface> interfaces = new ArrayList<AbstractReport.NetworkInterface>();

        public List<AbstractReport.NetworkInterface> getInterfaces() {
            return this.interfaces;
        }
    }
}

