/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.sysreport.generate;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.ApplianceConfiguration;
import org.openthinclient.sysreport.AbstractReport;
import org.openthinclient.sysreport.generate.ReportContributor;

public class ServerReportContributor
implements ReportContributor<AbstractReport> {
    private static final String VM_VERSION_PATH = "/usr/local/share/openthinclient/openthinclient-vm-version";
    public static final Set<String> ENV_WHITELIST;
    private final ManagerHome managerHome;

    public ServerReportContributor(ManagerHome managerHome) {
        this.managerHome = managerHome;
    }

    @Override
    public void contribute(AbstractReport report) {
        report.getServer().setServerId(this.managerHome.getMetadata().getServerID());
        boolean isAppliance = false;
        String applianceVersion = "";
        try {
            isAppliance = ApplianceConfiguration.get((ManagerHome)this.managerHome).isEnabled();
            applianceVersion = new String(Files.readAllBytes(Paths.get(VM_VERSION_PATH, new String[0])));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        report.getServer().setIsAppliance(isAppliance);
        report.getServer().setApplianceVersion(applianceVersion);
        report.getServer().getOS().setArch(SystemUtils.OS_ARCH);
        report.getServer().getOS().setName(SystemUtils.OS_NAME);
        report.getServer().getOS().setVersion(SystemUtils.OS_VERSION);
        Map<String, String> env = System.getenv();
        ArrayList<String> keys = new ArrayList<String>();
        HashMap<String, String> filtered = new HashMap<String, String>();
        env.forEach((key, value) -> {
            if (ENV_WHITELIST.contains(key.toLowerCase())) {
                filtered.put((String)key, (String)value);
            }
            keys.add((String)key);
        });
        report.getServer().setEnvironment(filtered);
        report.getServer().setEnvironmentKeys(keys);
    }

    static {
        HashSet<String> whitelist = new HashSet<String>();
        whitelist.add("LC_CTYPE".toLowerCase());
        whitelist.add("LANG".toLowerCase());
        whitelist.add("TERM".toLowerCase());
        ENV_WHITELIST = Collections.unmodifiableSet(whitelist);
    }
}

