/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.manager.util.installation;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Comparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallationDirectoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(InstallationDirectoryUtil.class);
    private static final String INSTALL_FILE_NAME = ".installation.txt";

    public static void cleanupManagerHomeDirectory(Path managerHomeDirectory) {
        LOG.info("Delete manager home", (Object)managerHomeDirectory);
        Path logFile = Paths.get(managerHomeDirectory.toString(), "logs", "openthinclient-manager.log");
        try {
            Files.walk(managerHomeDirectory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).filter(path -> !logFile.startsWith((Path)path)).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            LOG.error("Cannot cleanup manager home directory '" + managerHomeDirectory.toAbsolutePath() + "' to prepare installation.", (Throwable)e);
        }
    }

    public static void removeInstallationFile(Path managerHomeDirectory) {
        Path installFile = Paths.get(managerHomeDirectory.toString(), INSTALL_FILE_NAME);
        if (Files.exists(installFile, new LinkOption[0])) {
            LOG.info("Removing existing installation file {}", (Object)installFile);
            try {
                Files.delete(installFile);
            }
            catch (IOException e) {
                LOG.error("Cannot delete file " + installFile, (Throwable)e);
            }
        }
    }

    public static void createInstallationProgressFile(Path managerHomeDirectory) {
        Path installProgress = Paths.get(managerHomeDirectory.toString(), INSTALL_FILE_NAME);
        LOG.debug("Creating new installation file");
        try {
            Files.createDirectories(managerHomeDirectory, new FileAttribute[0]);
            Files.createFile(installProgress, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOG.error("Cannot create file " + installProgress, (Throwable)e);
        }
    }

    public static void appendText(File managerHomeDirectory, String content) {
        Path installFile = Paths.get(managerHomeDirectory.getPath(), INSTALL_FILE_NAME);
        try {
            Files.write(installFile, Collections.singleton(content), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.error("Cannot write content '" + content + "' to file " + installFile, (Throwable)e);
        }
    }

    public static boolean existsInstallationProgressFile(File managerHomeDirectory) {
        return Files.exists(Paths.get(managerHomeDirectory.getPath(), INSTALL_FILE_NAME), new LinkOption[0]);
    }

    public static boolean isInstallationDirectoryEmpty(File directory) {
        return InstallationDirectoryUtil.isInstallationDirectoryEmpty(directory, false);
    }

    public static boolean isInstallationDirectoryEmpty(File directory, boolean ignoreInstallFile) {
        File[] contents = directory.listFiles(pathname -> !pathname.getName().equals(".DS_Store") && !pathname.getName().equals("logs") && !pathname.getName().equals(".otc-manager-home.meta"));
        boolean existingInstallFile = Files.exists(Paths.get(directory.getPath(), INSTALL_FILE_NAME), new LinkOption[0]);
        if (ignoreInstallFile) {
            return contents != null && contents.length == 0;
        }
        return contents != null && contents.length == 0 && !existingInstallFile;
    }

    public static boolean doesInstallationDirectoryContainNecessaryFiles(File managerHomeDirectory) {
        return Files.exists(Paths.get(managerHomeDirectory.getPath(), "db.xml"), new LinkOption[0]) && Files.exists(Paths.get(managerHomeDirectory.getPath(), "directory", "service.xml"), new LinkOption[0]) && Files.exists(Paths.get(managerHomeDirectory.getPath(), "nfs", "service.xml"), new LinkOption[0]) && Files.exists(Paths.get(managerHomeDirectory.getPath(), "package-manager.xml"), new LinkOption[0]) && Files.exists(Paths.get(managerHomeDirectory.getPath(), "tftp.xml"), new LinkOption[0]);
    }
}

