/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.progress;

import org.openthinclient.progress.ProgressReceiver;

public abstract class AbstractProgressReceiver
implements ProgressReceiver {
    @Override
    public ProgressReceiver subprogress(double progressMin, double progressMax) {
        return new SimpleSubprogressReceiver(this, progressMin, progressMax - progressMin);
    }

    public static class SimpleSubprogressReceiver
    implements ProgressReceiver {
        private final ProgressReceiver parent;
        private final double progressMin;
        private final double progressAmount;

        public SimpleSubprogressReceiver(ProgressReceiver parent, double progressMin, double progressAmount) {
            this.parent = parent;
            this.progressMin = progressMin;
            this.progressAmount = progressAmount;
        }

        @Override
        public void progress(String message, double progress) {
            this.parent.progress(message, this.progressMin + progress * this.progressAmount);
        }

        @Override
        public void progress(String message) {
            this.parent.progress(message);
        }

        @Override
        public void progress(double progress) {
            this.parent.progress(this.progressMin + progress * this.progressAmount);
        }

        @Override
        public ProgressReceiver subprogress(double progressMin, double progressMax) {
            return new SimpleSubprogressReceiver(this, progressMin, progressMax - progressMin);
        }

        @Override
        public void completed() {
            this.parent.completed();
        }
    }
}

