/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import java.util.Enumeration;
import java.util.Hashtable;

public class DHCPOptions {
    private Hashtable optionsTable = new Hashtable();

    public void removeOption(byte entryCode) {
        this.optionsTable.remove(new Byte(entryCode));
    }

    public boolean contains(byte entryCode) {
        return this.optionsTable.containsKey(new Byte(entryCode));
    }

    public boolean isEmpty() {
        return this.optionsTable.isEmpty();
    }

    public byte[] getOption(byte entryCode) {
        if (this.contains(entryCode)) {
            DHCPOptionsEntry ent = (DHCPOptionsEntry)this.optionsTable.get(new Byte(entryCode));
            return ent.content;
        }
        return null;
    }

    public void setOption(byte entryCode, byte[] value) {
        DHCPOptionsEntry opt = new DHCPOptionsEntry(entryCode, (byte)value.length, value);
        this.optionsTable.put(new Byte(entryCode), opt);
    }

    private byte[] getArrayOption(int length, int position, byte[] options) {
        byte[] value = new byte[length];
        for (int i = 0; i < length; ++i) {
            value[i] = options[position + i];
        }
        return value;
    }

    public void internalize(byte[] optionsArray) {
        int pos = 4;
        while (optionsArray[pos] != -1) {
            byte code = optionsArray[pos++];
            byte length = optionsArray[pos++];
            byte[] value = this.getArrayOption(length, pos, optionsArray);
            this.setOption(code, value);
            pos += length;
        }
    }

    public byte[] externalize() {
        byte[] options = new byte[312];
        options[0] = 99;
        options[1] = -126;
        options[2] = 83;
        options[3] = 99;
        int position = 4;
        Enumeration e = this.optionsTable.elements();
        while (e.hasMoreElements()) {
            DHCPOptionsEntry entry = (DHCPOptionsEntry)e.nextElement();
            options[position++] = entry.code;
            options[position++] = entry.length;
            for (int i = 0; i < entry.length; ++i) {
                options[position++] = entry.content[i];
            }
        }
        options[position] = -1;
        return options;
    }

    public void printList() {
        System.out.println(this.optionsTable.toString());
    }

    class DHCPOptionsEntry {
        protected byte code;
        protected byte length;
        protected byte[] content;

        public DHCPOptionsEntry(byte entryCode, byte entryLength, byte[] entryContent) {
            this.code = entryCode;
            this.length = entryLength;
            this.content = entryContent;
        }
    }
}

