/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.check;

import java.util.function.Consumer;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.concurrent.ListenableFuture;

public class CheckTask<T> {
    private static final Logger LOG = LoggerFactory.getLogger(CheckTask.class);
    private final ListenableFuture<CheckExecutionResult<T>> future;

    public CheckTask(ListenableFuture<CheckExecutionResult<T>> future) {
        this.future = future;
    }

    public void onResult(Consumer<CheckExecutionResult<T>> consumer) {
        this.future.addCallback(consumer::accept, ex -> {
            LOG.error("Check execution failed.", ex);
            consumer.accept(new CheckExecutionResult(CheckExecutionResult.CheckResultType.FAILED));
        });
    }

    public void cancel() {
        try {
            this.future.cancel(true);
        }
        catch (Exception e) {
            LOG.error("Failed to cancel running check task", (Throwable)e);
        }
    }
}

