/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.swing;

import com.google.common.base.Strings;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.openthinclient.advisor.cVerwaltung;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;

public class ProxyConfigurationDialog
extends JDialog {
    private final NetworkConfiguration.ProxyConfiguration proxyConfiguration;
    private JButton jBtnProxyAbort;
    private JButton jBtnProxyOK;
    private JCheckBox jCBoxProxy;
    private JLabel jLbProxyhost;
    private JLabel jLbProxyport;
    private JTextField jTxtProxyHost;
    private JTextField jTxtProxyPort;

    public ProxyConfigurationDialog(NetworkConfiguration.ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        this.initComponents();
        this.setModal(true);
        this.centerGUI(this);
        this.readProxySettings();
    }

    public NetworkConfiguration.ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    private void readProxySettings() {
        this.jCBoxProxy.setSelected(this.proxyConfiguration.isEnabled());
        this.updateEnabledState();
        this.jTxtProxyHost.setText(this.proxyConfiguration.getHost());
        this.jTxtProxyPort.setText(String.valueOf(this.proxyConfiguration.getPort()));
    }

    private void updateEnabledState() {
        this.jTxtProxyHost.setEnabled(this.jCBoxProxy.isSelected());
        this.jTxtProxyPort.setEnabled(this.jCBoxProxy.isSelected());
    }

    private boolean validateAndSave() {
        int proxyPort;
        String hostText = this.jTxtProxyHost.getText();
        String proxyPortText = this.jTxtProxyPort.getText();
        if (!this.jCBoxProxy.isSelected()) {
            this.proxyConfiguration.setEnabled(false);
            return true;
        }
        if (Strings.isNullOrEmpty((String)hostText)) {
            this.showError(this.jTxtProxyHost, "No hostname has been provided");
            return false;
        }
        if (Strings.isNullOrEmpty((String)proxyPortText)) {
            this.showError(this.jTxtProxyPort, "No port has been provided");
            return false;
        }
        try {
            proxyPort = Integer.parseInt(proxyPortText);
        }
        catch (NumberFormatException e) {
            this.showError(this.jTxtProxyPort, "Given port is not a number");
            return false;
        }
        this.proxyConfiguration.setEnabled(true);
        this.proxyConfiguration.setHost(hostText);
        this.proxyConfiguration.setPort(proxyPort);
        return true;
    }

    protected void showError(JComponent component, String message) {
        JOptionPane.showMessageDialog(this, message, "Incorrect input", 0);
    }

    private void centerGUI(Window gui) {
        Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();
        double width = dm.getWidth();
        double height = dm.getHeight();
        double xPosition = width / 2.0 - (double)(gui.getWidth() / 2);
        double yPosition = height / 2.0 - (double)(gui.getHeight() / 2);
        gui.setLocation((int)xPosition, (int)yPosition);
    }

    private void Abbruch() {
        this.dispose();
    }

    private void initComponents() {
        this.jLbProxyhost = new JLabel();
        this.jTxtProxyHost = new JTextField();
        this.jLbProxyport = new JLabel();
        this.jCBoxProxy = new JCheckBox();
        this.jTxtProxyPort = new JTextField();
        this.jBtnProxyOK = new JButton();
        this.jBtnProxyAbort = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Proxy settings");
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProxyConfigurationDialog.this.formWindowClosing(evt);
            }
        });
        this.jLbProxyhost.setText("Proxyhost");
        this.jLbProxyport.setText("Proxyport");
        this.jCBoxProxy.setText("Use proxy");
        this.jCBoxProxy.addActionListener(e -> this.updateEnabledState());
        this.jBtnProxyOK.setText("OK");
        this.jBtnProxyOK.addActionListener(e -> {
            if (this.validateAndSave()) {
                cVerwaltung.setProxySettings(this.proxyConfiguration);
                this.dispose();
            }
        });
        this.jBtnProxyAbort.setText("Cancel");
        this.jBtnProxyAbort.addActionListener(e -> this.Abbruch());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(144, 144, 144).addComponent(this.jCBoxProxy).addContainerGap(187, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(68, 68, 68).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLbProxyhost).addComponent(this.jLbProxyport)).addGap(25, 25, 25)).addComponent(this.jBtnProxyOK)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE).addComponent(this.jBtnProxyAbort).addGap(100, 100, 100)).addGroup(layout.createSequentialGroup().addGap(56, 56, 56).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jTxtProxyPort, GroupLayout.Alignment.LEADING, -1, 124, Short.MAX_VALUE).addComponent(this.jTxtProxyHost, GroupLayout.Alignment.LEADING, -1, 124, Short.MAX_VALUE)).addContainerGap(84, Short.MAX_VALUE)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jCBoxProxy).addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLbProxyhost).addComponent(this.jTxtProxyHost, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLbProxyport).addComponent(this.jTxtProxyPort, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jBtnProxyOK).addComponent(this.jBtnProxyAbort)).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.Abbruch();
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            ProxyConfigurationDialog configDialog = new ProxyConfigurationDialog(new NetworkConfiguration.ProxyConfiguration());
            configDialog.setVisible(true);
            NetworkConfiguration.ProxyConfiguration config = configDialog.getProxyConfiguration();
            System.out.println(config.isEnabled());
            System.out.println(config.getHost());
            System.out.println(config.getPort());
        });
    }
}

