/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.check;

import java.util.concurrent.Callable;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheck<T>
implements Callable<CheckExecutionResult<T>> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final String description;

    public AbstractCheck(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public final CheckExecutionResult<T> call() throws Exception {
        this.log.info("Starting check...");
        CheckExecutionResult<T> result = this.perform();
        this.log.info("Check finished. Result: " + result);
        return result;
    }

    protected abstract CheckExecutionResult<T> perform();
}

