/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.check;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import java.nio.file.Path;
import java.util.Locale;
import java.util.function.Supplier;
import org.openthinclient.advisor.AdvisorMessages;
import org.openthinclient.advisor.check.AbstractCheck;
import org.openthinclient.advisor.check.CheckExecutionResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckFilesystemFreeSpace
extends AbstractCheck<Boolean> {
    public static final String MANAGER_HOME_DIRECTORY = "managerHomeInstallDir";
    private static final Logger LOG = LoggerFactory.getLogger(CheckFilesystemFreeSpace.class);
    private final long minFreeSpace;
    private final Supplier<Path> pathSupplier;
    protected IMessageConveyor mc = new MessageConveyor(null);

    public CheckFilesystemFreeSpace(Locale locale, Supplier<Path> pathSupplier, long minFreeSpace) {
        super(minFreeSpace > 0L ? new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKFILESYSTEMFREESPACE_FREESPACE_MINIMUM, new Object[]{minFreeSpace}) : new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKFILESYSTEMFREESPACE_SKIPED, new Object[0]), new MessageConveyor(locale).getMessage((Enum)AdvisorMessages.ADVISOR_CHECKFILESYSTEMFREESPACE_DESCRIPTION, new Object[0]));
        this.minFreeSpace = minFreeSpace;
        this.pathSupplier = pathSupplier;
    }

    @Override
    protected CheckExecutionResult<Boolean> perform() {
        Path installDir = this.pathSupplier.get();
        long freeSpace = installDir.getRoot().toFile().getFreeSpace();
        LOG.info("Free space for '" + installDir.getRoot() + "' is " + freeSpace + " bytes (" + freeSpace / 1024L / 1024L + "Mb)");
        if (this.minFreeSpace == 0L) {
            return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.WARNING, true);
        }
        if (freeSpace > this.minFreeSpace * 1024L * 1024L) {
            return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.SUCCESS, true);
        }
        return new CheckExecutionResult<Boolean>(CheckExecutionResult.CheckResultType.FAILED, false);
    }
}

