/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import edu.bucknell.net.JDHCP.DHCPOptions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class DHCPMessage {
    private byte op;
    private byte htype;
    private byte hlen;
    private byte hops;
    private int xid;
    private short secs;
    private short flags;
    private byte[] ciaddr = new byte[4];
    private byte[] yiaddr = new byte[4];
    private byte[] siaddr = new byte[4];
    private byte[] giaddr = new byte[4];
    private byte[] chaddr = new byte[16];
    private byte[] sname = new byte[64];
    private byte[] file = new byte[128];
    private DHCPOptions optionsList = null;
    private int gPort;
    private InetAddress destination_IP;
    public static final int CLIENT_PORT = 68;
    public static final int SERVER_PORT = 67;
    public static InetAddress BROADCAST_ADDR = null;
    public static final int DISCOVER = 1;
    public static final int OFFER = 2;
    public static final int REQUEST = 3;
    public static final int DECLINE = 4;
    public static final int ACK = 5;
    public static final int NAK = 6;
    public static final int RELEASE = 7;
    public static final int INFORM = 8;

    public DHCPMessage() {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
    }

    public DHCPMessage(DHCPMessage inMessage) {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
        this.op = inMessage.getOp();
        this.htype = inMessage.getHtype();
        this.hlen = inMessage.getHlen();
        this.hops = inMessage.getHops();
        this.xid = inMessage.getXid();
        this.secs = inMessage.getSecs();
        this.flags = inMessage.getFlags();
        this.ciaddr = inMessage.getCiaddr();
        this.yiaddr = inMessage.getYiaddr();
        this.siaddr = inMessage.getSiaddr();
        this.giaddr = inMessage.getGiaddr();
        this.chaddr = inMessage.getChaddr();
        this.sname = inMessage.getSname();
        this.file = inMessage.getFile();
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage inMessage, InetAddress inServername, int inPort) {
        this.Initialize();
        this.destination_IP = inServername;
        this.gPort = inPort;
        this.op = inMessage.getOp();
        this.htype = inMessage.getHtype();
        this.hlen = inMessage.getHlen();
        this.hops = inMessage.getHops();
        this.xid = inMessage.getXid();
        this.secs = inMessage.getSecs();
        this.flags = inMessage.getFlags();
        this.ciaddr = inMessage.getCiaddr();
        this.yiaddr = inMessage.getYiaddr();
        this.siaddr = inMessage.getSiaddr();
        this.giaddr = inMessage.getGiaddr();
        this.chaddr = inMessage.getChaddr();
        this.sname = inMessage.getSname();
        this.file = inMessage.getFile();
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(DHCPMessage inMessage, InetAddress inServername) {
        this.Initialize();
        this.destination_IP = inServername;
        this.gPort = 67;
        this.op = inMessage.getOp();
        this.htype = inMessage.getHtype();
        this.hlen = inMessage.getHlen();
        this.hops = inMessage.getHops();
        this.xid = inMessage.getXid();
        this.secs = inMessage.getSecs();
        this.flags = inMessage.getFlags();
        this.ciaddr = inMessage.getCiaddr();
        this.yiaddr = inMessage.getYiaddr();
        this.siaddr = inMessage.getSiaddr();
        this.giaddr = inMessage.getGiaddr();
        this.chaddr = inMessage.getChaddr();
        this.sname = inMessage.getSname();
        this.file = inMessage.getFile();
        this.optionsList.internalize(inMessage.getOptions());
    }

    public DHCPMessage(InetAddress inServername, int inPort) {
        this.Initialize();
        this.destination_IP = inServername;
        this.gPort = inPort;
    }

    public DHCPMessage(InetAddress inServername) {
        this.Initialize();
        this.destination_IP = inServername;
        this.gPort = 67;
    }

    public DHCPMessage(int inPort) {
        this.Initialize();
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf) {
        this.Initialize();
        this.internalize(ibuf);
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = 67;
    }

    public DHCPMessage(byte[] ibuf, InetAddress inServername, int inPort) {
        this.Initialize();
        this.internalize(ibuf);
        this.destination_IP = inServername;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf, int inPort) {
        this.Initialize();
        this.internalize(ibuf);
        this.destination_IP = BROADCAST_ADDR;
        this.gPort = inPort;
    }

    public DHCPMessage(byte[] ibuf, InetAddress inServername) {
        this.Initialize();
        this.internalize(ibuf);
        this.destination_IP = inServername;
        this.gPort = 67;
    }

    public DHCPMessage(DataInputStream inStream) {
        this.Initialize();
        try {
            this.op = inStream.readByte();
            this.htype = inStream.readByte();
            this.hlen = inStream.readByte();
            this.hops = inStream.readByte();
            this.xid = inStream.readInt();
            this.secs = inStream.readShort();
            this.flags = inStream.readShort();
            inStream.readFully(this.ciaddr, 0, 4);
            inStream.readFully(this.yiaddr, 0, 4);
            inStream.readFully(this.siaddr, 0, 4);
            inStream.readFully(this.giaddr, 0, 4);
            inStream.readFully(this.chaddr, 0, 16);
            inStream.readFully(this.sname, 0, 64);
            inStream.readFully(this.file, 0, 128);
            byte[] options = new byte[312];
            inStream.readFully(options, 0, 312);
            this.optionsList.internalize(options);
        }
        catch (IOException e) {
            System.err.println(e);
        }
    }

    private void Initialize() {
        this.optionsList = new DHCPOptions();
    }

    public synchronized byte[] externalize() {
        ByteArrayOutputStream outBStream = new ByteArrayOutputStream();
        DataOutputStream outStream = new DataOutputStream(outBStream);
        try {
            outStream.writeByte(this.op);
            outStream.writeByte(this.htype);
            outStream.writeByte(this.hlen);
            outStream.writeByte(this.hops);
            outStream.writeInt(this.xid);
            outStream.writeShort(this.secs);
            outStream.writeShort(this.flags);
            outStream.write(this.ciaddr, 0, 4);
            outStream.write(this.yiaddr, 0, 4);
            outStream.write(this.siaddr, 0, 4);
            outStream.write(this.giaddr, 0, 4);
            outStream.write(this.chaddr, 0, 16);
            outStream.write(this.sname, 0, 64);
            outStream.write(this.file, 0, 128);
            byte[] options = new byte[312];
            if (this.optionsList == null) {
                this.Initialize();
            }
            options = this.optionsList.externalize();
            outStream.write(options, 0, 312);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        byte[] data = outBStream.toByteArray();
        return data;
    }

    public synchronized DHCPMessage internalize(byte[] ibuff) {
        ByteArrayInputStream inBStream = new ByteArrayInputStream(ibuff, 0, ibuff.length);
        DataInputStream inStream = new DataInputStream(inBStream);
        try {
            this.op = inStream.readByte();
            this.htype = inStream.readByte();
            this.hlen = inStream.readByte();
            this.hops = inStream.readByte();
            this.xid = inStream.readInt();
            this.secs = inStream.readShort();
            this.flags = inStream.readShort();
            inStream.readFully(this.ciaddr, 0, 4);
            inStream.readFully(this.yiaddr, 0, 4);
            inStream.readFully(this.siaddr, 0, 4);
            inStream.readFully(this.giaddr, 0, 4);
            inStream.readFully(this.chaddr, 0, 16);
            inStream.readFully(this.sname, 0, 64);
            inStream.readFully(this.file, 0, 128);
            byte[] options = new byte[312];
            inStream.readFully(options, 0, 312);
            if (this.optionsList == null) {
                this.Initialize();
            }
            this.optionsList.internalize(options);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return this;
    }

    public void setOp(byte inOp) {
        this.op = inOp;
    }

    public void setHtype(byte inHtype) {
        this.htype = inHtype;
    }

    public void setHlen(byte inHlen) {
        this.hlen = inHlen;
    }

    public void setHops(byte inHops) {
        this.hops = inHops;
    }

    public void setXid(int inXid) {
        this.xid = inXid;
    }

    public void setSecs(short inSecs) {
        this.secs = inSecs;
    }

    public void setFlags(short inFlags) {
        this.flags = inFlags;
    }

    public void setCiaddr(byte[] inCiaddr) {
        this.ciaddr = inCiaddr;
    }

    public void setYiaddr(byte[] inYiaddr) {
        this.yiaddr = inYiaddr;
    }

    public void setSiaddr(byte[] inSiaddr) {
        this.siaddr = inSiaddr;
    }

    public void setGiaddr(byte[] inGiaddr) {
        this.giaddr = inGiaddr;
    }

    public void setChaddr(byte[] inChaddr) {
        this.chaddr = inChaddr;
    }

    public void setSname(byte[] inSname) {
        this.sname = inSname;
    }

    public void setFile(byte[] inFile) {
        this.file = inFile;
    }

    public void setPort(int inPortNum) {
        this.gPort = inPortNum;
    }

    public void setDestinationHost(String inHost) {
        try {
            this.destination_IP = InetAddress.getByName(inHost);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public byte getOp() {
        return this.op;
    }

    public byte getHtype() {
        return this.htype;
    }

    public byte getHlen() {
        return this.hlen;
    }

    public byte getHops() {
        return this.hops;
    }

    public int getXid() {
        return this.xid;
    }

    public short getSecs() {
        return this.secs;
    }

    public short getFlags() {
        return this.flags;
    }

    public byte[] getCiaddr() {
        return this.ciaddr;
    }

    public byte[] getYiaddr() {
        return this.yiaddr;
    }

    public byte[] getSiaddr() {
        return this.siaddr;
    }

    public byte[] getGiaddr() {
        return this.giaddr;
    }

    public byte[] getChaddr() {
        return this.chaddr;
    }

    public byte[] getSname() {
        return this.sname;
    }

    public byte[] getFile() {
        return this.file;
    }

    public byte[] getOptions() {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.externalize();
    }

    public int getPort() {
        return this.gPort;
    }

    public String getDestinationAddress() {
        return this.destination_IP.getHostAddress();
    }

    public void setOption(int inOptNum, byte[] inOptionData) {
        this.optionsList.setOption((byte)inOptNum, inOptionData);
    }

    public byte[] getOption(int inOptNum) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.getOption((byte)inOptNum);
    }

    public void removeOption(int inOptNum) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        this.optionsList.removeOption((byte)inOptNum);
    }

    public boolean IsOptSet(int inOptNum) {
        if (this.optionsList == null) {
            this.Initialize();
        }
        return this.optionsList.contains((byte)inOptNum);
    }

    public void printMessage() {
        byte[] data = this.externalize();
        for (int i = 0; i < 100; ++i) {
            System.out.print(data[i]);
            if (i % 25 == 0 && i != 0) {
                System.out.print("\n");
                continue;
            }
            System.out.print(" ");
        }
        System.out.print("\n");
        if (this.optionsList == null) {
            this.Initialize();
        }
        this.optionsList.printList();
    }

    static {
        if (BROADCAST_ADDR == null) {
            try {
                BROADCAST_ADDR = InetAddress.getByName("255.255.255.255");
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }
}

