/*
 * Decompiled with CFR 0.152.
 */
package edu.bucknell.net.JDHCP;

import edu.bucknell.net.JDHCP.DHCPMessage;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class DHCPSocket
extends DatagramSocket {
    protected static int PACKET_SIZE = 1500;
    private int defaultSOTIME_OUT = 3000;
    private DatagramSocket gSocket = null;

    public DHCPSocket(int inPort) throws SocketException {
        super(inPort);
        this.setSoTimeout(this.defaultSOTIME_OUT);
    }

    public void setMTU(int inSize) {
        PACKET_SIZE = inSize;
    }

    public int getMTU() {
        return PACKET_SIZE;
    }

    public synchronized void send(DHCPMessage inMessage) throws IOException {
        byte[] data = new byte[PACKET_SIZE];
        data = inMessage.externalize();
        InetAddress dest = null;
        try {
            dest = InetAddress.getByName(inMessage.getDestinationAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        DatagramPacket outgoing = new DatagramPacket(data, data.length, dest, inMessage.getPort());
        this.send(outgoing);
    }

    public synchronized boolean receive(DHCPMessage outMessage) {
        try {
            DatagramPacket incoming = new DatagramPacket(new byte[PACKET_SIZE], PACKET_SIZE);
            this.receive(incoming);
            outMessage.internalize(incoming.getData());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

