/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor;

import edu.bucknell.net.JDHCP.DHCPMessage;
import edu.bucknell.net.JDHCP.DHCPSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.StringTokenizer;
import org.openthinclient.advisor.cDHCPClient;

class Client
extends Thread {
    DHCPSocket bindSocket = null;
    byte[] hwaddr = new byte[16];
    InetAddress serverIP;
    int portNum;
    boolean gSentinel;
    static final int REQUESTED_IP = 50;
    static final int LEASE_TIME = 51;
    static final int MESSAGE_TYPE = 53;
    static final int T1_TIME = 58;
    static final int T2_TIME = 59;
    private String Ergebnis = "";

    public Client(DHCPSocket inSocket, String inHwaddr) {
        this.bindSocket = inSocket;
        this.hwaddr = this.ChaddrToByte(inHwaddr);
        this.setName(inHwaddr);
        this.serverIP = DHCPMessage.BROADCAST_ADDR;
        this.portNum = 67;
        this.gSentinel = true;
    }

    @Override
    public void run() {
        try {
            DHCPMessage offerMessageIn = new DHCPMessage(this.serverIP, this.portNum);
            DHCPMessage messageIn = offerMessageIn = this.SendDiscover();
            byte[] messageType = new byte[1];
            block7: while (this.gSentinel) {
                messageType = messageIn.getOption(53);
                switch (messageType[0]) {
                    case 2: {
                        this.Ergebnis = this.Ergebnis + this.getName() + " received a DHCPOFFER for " + this.bytesToString(messageIn.getYiaddr()) + " \r\n";
                        messageIn = this.SendRequest(messageIn);
                        continue block7;
                    }
                    case 5: {
                        byte[] t1 = new byte[4];
                        byte[] t2 = new byte[4];
                        t1 = messageIn.getOption(58);
                        t2 = messageIn.getOption(59);
                        this.Ergebnis = this.Ergebnis + "Binding to IP address: " + this.bytesToString(messageIn.getYiaddr()) + " \r\n";
                        cDHCPClient.setErgebnis(this.Ergebnis);
                        cDHCPClient.setWorks(true);
                        this.gSentinel = false;
                        continue block7;
                    }
                    case 6: {
                        System.out.println(this.getName());
                        System.out.print("Revieded DHCPNAK... ");
                        messageIn = this.SendDiscover();
                        continue block7;
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private DHCPMessage SendDiscover() {
        Random ranXid = new Random();
        DHCPMessage messageIn = new DHCPMessage(this.serverIP, this.portNum);
        DHCPMessage messageOut = new DHCPMessage(this.serverIP, this.portNum);
        try {
            messageOut.setOp((byte)1);
            messageOut.setHtype((byte)1);
            messageOut.setHlen((byte)6);
            messageOut.setHops((byte)0);
            messageOut.setXid(ranXid.nextInt());
            messageOut.setSecs((short)0);
            messageOut.setFlags((short)0);
            messageOut.setChaddr(this.hwaddr);
            byte[] opt = new byte[]{1};
            messageOut.setOption(53, opt);
            this.bindSocket.send(messageOut);
            this.Ergebnis = "Sending DHCPDISCOVER with MAC Address: " + this.getName() + " \r\n";
            boolean sentinal = true;
            while (sentinal) {
                if (this.bindSocket.receive(messageIn)) {
                    if (messageOut.getXid() == messageIn.getXid()) {
                        sentinal = false;
                        continue;
                    }
                    this.bindSocket.send(messageOut);
                    continue;
                }
                this.bindSocket.send(messageOut);
            }
        }
        catch (SocketException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println("dhcpclient::SendDiscover:" + e);
        }
        return messageIn;
    }

    private DHCPMessage SendRequest(DHCPMessage offerMessageIn) {
        DHCPMessage messageOut = new DHCPMessage(this.serverIP, this.portNum);
        DHCPMessage messageIn = new DHCPMessage(this.serverIP, this.portNum);
        try {
            messageOut = offerMessageIn;
            messageOut.setOp((byte)1);
            byte[] opt = new byte[]{3};
            messageOut.setOption(53, opt);
            messageOut.setOption(50, offerMessageIn.getYiaddr());
            this.bindSocket.send(messageOut);
            this.Ergebnis = this.Ergebnis + this.getName() + " sending DHCPREQUEST for " + this.bytesToString(offerMessageIn.getOption(50)) + " \r\n";
            cDHCPClient.setErgebnis(this.Ergebnis);
            boolean sentinal = true;
            while (sentinal) {
                if (this.bindSocket.receive(messageIn)) {
                    if (messageOut.getXid() == messageIn.getXid()) {
                        sentinal = false;
                        continue;
                    }
                    this.bindSocket.send(messageOut);
                    continue;
                }
                this.bindSocket.send(messageOut);
            }
        }
        catch (SocketException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return messageIn;
    }

    private DHCPMessage ReNew(DHCPMessage offerMessageIn) {
        String server_IP = this.bytesToString(offerMessageIn.getSiaddr());
        DHCPMessage messageOut = null;
        try {
            messageOut = new DHCPMessage(InetAddress.getByName(server_IP), this.portNum);
        }
        catch (UnknownHostException ex) {
            System.err.println(ex);
        }
        DHCPMessage messageIn = new DHCPMessage(this.serverIP, this.portNum);
        try {
            messageOut = offerMessageIn;
            messageOut.setOp((byte)1);
            byte[] opt = new byte[]{3};
            messageOut.setOption(53, opt);
            messageOut.setCiaddr(offerMessageIn.getYiaddr());
            int so_timeout = this.bindSocket.getSoTimeout() / 1000;
            long t1 = this.byteToLong(offerMessageIn.getOption(58));
            long t2 = this.byteToLong(offerMessageIn.getOption(59));
            int elpstime = 1;
            this.bindSocket.send(messageOut);
            boolean sentinal = true;
            while (sentinal) {
                if ((long)(elpstime * so_timeout) + t1 >= t2) {
                    System.out.print(this.getName());
                    System.out.println(" rebinding, T1 has ran out...");
                    messageIn = this.ReBind(offerMessageIn);
                    break;
                }
                if (this.bindSocket.receive(messageIn)) {
                    sentinal = false;
                    break;
                }
                this.bindSocket.send(messageOut);
                ++elpstime;
            }
        }
        catch (SocketException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return messageIn;
    }

    private DHCPMessage ReBind(DHCPMessage offerMessageIn) {
        DHCPMessage messageOut = new DHCPMessage(this.serverIP, this.portNum);
        DHCPMessage messageIn = new DHCPMessage(this.serverIP, this.portNum);
        try {
            messageOut = offerMessageIn;
            messageOut.setOp((byte)1);
            byte[] opt = new byte[]{3};
            messageOut.setOption(53, opt);
            messageOut.setCiaddr(offerMessageIn.getYiaddr());
            long leaseTime = this.byteToLong(offerMessageIn.getOption(51));
            long t2 = this.byteToLong(offerMessageIn.getOption(59));
            int so_timeout = this.bindSocket.getSoTimeout() / 1000;
            int elpstime = 1;
            this.bindSocket.send(messageOut);
            boolean sentinal = true;
            while (sentinal) {
                if ((long)(elpstime * so_timeout) + t2 >= leaseTime) {
                    System.out.print(this.getName());
                    System.out.print(" is sending DHCPRELEASE, T2 has ran out ");
                    System.out.println("shuttingdown.");
                    this.SendRelease(offerMessageIn);
                    break;
                }
                if (this.bindSocket.receive(messageIn)) {
                    if (messageOut.getXid() == messageIn.getXid()) {
                        sentinal = false;
                        continue;
                    }
                    this.bindSocket.send(messageOut);
                    ++elpstime;
                    continue;
                }
                this.bindSocket.send(messageOut);
                ++elpstime;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return messageIn;
    }

    private void SendRelease(DHCPMessage inOfferMessage) {
        DHCPMessage messageOut = new DHCPMessage(this.serverIP, this.portNum);
        try {
            messageOut = inOfferMessage;
            messageOut.setOp((byte)1);
            byte[] opt = new byte[]{7};
            messageOut.setOption(53, opt);
            this.bindSocket.send(messageOut);
            this.gSentinel = false;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    long byteToLong(byte[] inB) {
        long ttime = (char)inB[0] * 0x1000000 + (char)inB[1] * 65536 + (char)inB[2] * 256 + (char)inB[3];
        return ttime;
    }

    String bytesToString(byte[] inB) {
        String st = new String();
        for (int n = 0; n < 4; ++n) {
            st = st + (char)inB[n] % 256;
            if (n >= 3) continue;
            st = st + ".";
        }
        return st;
    }

    private byte[] ChaddrToByte(String inChaddr) {
        StringTokenizer token = new StringTokenizer(inChaddr, ":");
        Integer tempInt = new Integer(0);
        byte[] outHwaddr = new byte[16];
        for (int i = 0; i < 6; ++i) {
            int temp = Integer.parseInt(token.nextToken(), 16);
            outHwaddr[i] = (byte)temp;
        }
        return outHwaddr;
    }
}

