/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.advisor.check;

import org.openthinclient.advisor.check.AbstractCheck;
import org.openthinclient.advisor.check.CheckTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;

public class CheckExecutionEngine {
    private static final Logger LOG = LoggerFactory.getLogger(CheckExecutionEngine.class);
    private final AsyncListenableTaskExecutor taskExecutor;

    public CheckExecutionEngine() {
        this(CheckExecutionEngine.createDefaultExecutor());
    }

    public CheckExecutionEngine(AsyncListenableTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    private static AsyncListenableTaskExecutor createDefaultExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setMaxPoolSize(1);
        return executor;
    }

    public <T> CheckTask<T> execute(AbstractCheck<T> check) {
        LOG.info("Executing check '" + check + "'");
        ListenableFuture future = this.taskExecutor.submitListenable(check);
        return new CheckTask(future);
    }
}

