/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.spring.events.internal;

import org.vaadin.spring.events.Event;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.events.internal.ListenerCollection;

abstract class AbstractListenerWrapper
implements ListenerCollection.Listener {
    private static final long serialVersionUID = 6211420845165980671L;
    private final EventBus owningEventBus;
    private final Object listenerTarget;
    private final boolean includingPropagatingEvents;

    public AbstractListenerWrapper(EventBus owningEventBus, Object listenerTarget, boolean includingPropagatingEvents) {
        this.owningEventBus = owningEventBus;
        this.listenerTarget = listenerTarget;
        this.includingPropagatingEvents = includingPropagatingEvents;
    }

    protected abstract Class<?> getPayloadType();

    public Object getListenerTarget() {
        return this.listenerTarget;
    }

    @Override
    public boolean supports(Event<?> event) {
        Class<?> eventPayloadType = event.getPayload().getClass();
        return this.getPayloadType().isAssignableFrom(eventPayloadType) && (this.includingPropagatingEvents || event.getEventBus().equals(this.owningEventBus));
    }
}

