/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.jmx.JMXSubsystemAdd;
import org.jboss.as.jmx.RemotingConnectorResource;
import org.jboss.as.jmx.RemotingConnectorService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

class RemotingConnectorAdd
extends AbstractAddStepHandler {
    static final RemotingConnectorAdd INSTANCE = new RemotingConnectorAdd();

    private RemotingConnectorAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        if (operation.hasDefined("use-management-endpoint")) {
            RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        boolean useManagementEndpoint = true;
        if (model.hasDefined("use-management-endpoint")) {
            useManagementEndpoint = RemotingConnectorResource.USE_MANAGEMENT_ENDPOINT.resolveModelAttribute(context, model).asBoolean();
        }
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress parentAddress = address.subAddress(0, address.size() - 1);
        ModelNode jmxSubsystemModel = Resource.Tools.readModel((Resource)context.readResourceFromRoot(parentAddress, true));
        String resolvedDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "resolved");
        String expressionsDomain = JMXSubsystemAdd.getDomainName(context, jmxSubsystemModel, "expression");
        this.launchServices(context, verificationHandler, newControllers, useManagementEndpoint, resolvedDomain, expressionsDomain);
    }

    void launchServices(OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers, boolean useManagementEndpoint, String resolvedDomain, String expressionsDomain) {
        ServiceTarget target = context.getServiceTarget();
        ServiceController<?> controller = RemotingConnectorService.addService(target, verificationHandler, useManagementEndpoint, resolvedDomain, expressionsDomain);
        if (newControllers != null) {
            newControllers.add(controller);
        }
    }
}

