/*
 * Decompiled with CFR 0.152.
 */
package org.openide;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;

public abstract class ErrorManager {
    public static final int UNKNOWN = 0;
    public static final int INFORMATIONAL = 1;
    public static final int WARNING = 16;
    public static final int USER = 256;
    public static final int EXCEPTION = 4096;
    public static final int ERROR = 65536;
    private static DelegatingErrorManager current;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ErrorManager getDefault() {
        Class<ErrorManager> clazz = ErrorManager.class;
        synchronized (ErrorManager.class) {
            if (current != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return current;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ErrorManager.getDefaultDelegate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DelegatingErrorManager getDefaultDelegate() {
        DelegatingErrorManager c = new DelegatingErrorManager("");
        try {
            c.initialize();
            Class<ErrorManager> clazz = ErrorManager.class;
            synchronized (ErrorManager.class) {
                if (current == null) {
                    current = c;
                    ErrorManager.current.r.addLookupListener(current);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            current = c;
        }
        catch (LinkageError e) {
            e.printStackTrace();
            current = c;
        }
        {
            return current;
        }
    }

    public abstract Throwable attachAnnotations(Throwable var1, Annotation[] var2);

    public abstract Annotation[] findAnnotations(Throwable var1);

    public abstract Throwable annotate(Throwable var1, int var2, String var3, String var4, Throwable var5, Date var6);

    public abstract void notify(int var1, Throwable var2);

    public final void notify(Throwable t) {
        this.notify(0, t);
    }

    public abstract void log(int var1, String var2);

    public final void log(String s) {
        this.log(1, s);
    }

    public boolean isLoggable(int severity) {
        return true;
    }

    public boolean isNotifiable(int severity) {
        return this.isLoggable(severity);
    }

    public abstract ErrorManager getInstance(String var1);

    public final Throwable annotate(Throwable t, String localizedMessage) {
        return this.annotate(t, 0, null, localizedMessage, null, null);
    }

    public final Throwable annotate(Throwable target, Throwable t) {
        return this.annotate(target, 0, null, null, t, null);
    }

    public final Throwable copyAnnotation(Throwable t, Throwable copyFrom) {
        return this.annotate(t, 0, null, null, copyFrom, null);
    }

    private static class DelegatingErrorManager
    extends ErrorManager
    implements LookupListener {
        private String name = null;
        private Set delegates = new HashSet();
        private WeakSet createdByMe = new WeakSet();
        Lookup.Result r;

        public DelegatingErrorManager(String name) {
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ErrorManager getInstance(String name) {
            if (name == null || "".equals(name)) {
                return this;
            }
            DelegatingErrorManager dem = new DelegatingErrorManager(name);
            DelegatingErrorManager delegatingErrorManager = this;
            synchronized (delegatingErrorManager) {
                this.attachNewDelegates(dem, name);
                this.createdByMe.add(dem);
            }
            return dem;
        }

        public Throwable attachAnnotations(Throwable t, Annotation[] arr) {
            for (ErrorManager em : this.delegates) {
                em.attachAnnotations(t, arr);
            }
            return t;
        }

        public Annotation[] findAnnotations(Throwable t) {
            for (ErrorManager em : this.delegates) {
                Annotation[] res = em.findAnnotations(t);
                if (res == null || res.length <= 0) continue;
                return res;
            }
            return new Annotation[0];
        }

        public Throwable annotate(Throwable t, int severity, String message, String localizedMessage, Throwable stackTrace, Date date) {
            for (ErrorManager em : this.delegates) {
                em.annotate(t, severity, message, localizedMessage, stackTrace, date);
            }
            return t;
        }

        public void notify(int severity, Throwable t) {
            if (this.delegates.isEmpty()) {
                t.printStackTrace();
            }
            try {
                for (ErrorManager em : this.delegates) {
                    em.notify(severity, t);
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                t.printStackTrace();
            }
            catch (LinkageError e) {
                e.printStackTrace();
                t.printStackTrace();
            }
        }

        public void log(int severity, String s) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.log(UNKNOWN, ...) is not permitted");
            }
            if (this.delegates.isEmpty() && severity > 1) {
                String sev;
                switch (severity) {
                    case 16: {
                        sev = "WARNING";
                        break;
                    }
                    case 256: {
                        sev = "USER";
                        break;
                    }
                    case 4096: {
                        sev = "EXCEPTION";
                        break;
                    }
                    case 65536: {
                        sev = "ERROR";
                        break;
                    }
                    default: {
                        sev = String.valueOf(severity);
                    }
                }
                System.err.println("[" + sev + "] " + s);
            }
            for (ErrorManager em : this.delegates) {
                em.log(severity, s);
            }
        }

        public boolean isLoggable(int severity) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.isLoggable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty() && severity > 1) {
                return true;
            }
            for (ErrorManager em : this.delegates) {
                if (!em.isLoggable(severity)) continue;
                return true;
            }
            return false;
        }

        public boolean isNotifiable(int severity) {
            if (severity == 0) {
                throw new IllegalArgumentException("ErrorManager.isNotifiable(UNKNOWN) is not permitted");
            }
            if (this.delegates.isEmpty()) {
                return true;
            }
            for (ErrorManager em : this.delegates) {
                if (!em.isNotifiable(severity)) continue;
                return true;
            }
            return false;
        }

        public synchronized void setDelegates(Collection newDelegates) {
            LinkedHashSet d;
            this.delegates = d = new LinkedHashSet(newDelegates);
            for (DelegatingErrorManager dem : this.createdByMe) {
                this.attachNewDelegates(dem, dem.getName());
            }
        }

        private String getName() {
            return this.name;
        }

        private void attachNewDelegates(DelegatingErrorManager dem, String name) {
            HashSet<ErrorManager> newDelegatesForDem = new HashSet<ErrorManager>();
            for (ErrorManager e : this.delegates) {
                newDelegatesForDem.add(e.getInstance(name));
            }
            dem.setDelegates(newDelegatesForDem);
        }

        public void initialize() {
            this.r = Lookup.getDefault().lookup(new Lookup.Template(ErrorManager.class));
            Collection instances = this.r.allInstances();
            this.setDelegates(instances);
        }

        public void resultChanged(LookupEvent ev) {
            if (this.r != null) {
                Collection instances = this.r.allInstances();
                this.setDelegates(instances);
            }
        }
    }

    public static interface Annotation {
        public String getMessage();

        public String getLocalizedMessage();

        public Throwable getStackTrace();

        public Date getDate();

        public int getSeverity();
    }
}

