/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Enumerations;
import org.openide.util.Lookup;
import org.openide.util.lookup.ALPairComparator;
import org.openide.util.lookup.AbstractLookup;

final class InheritanceTree
implements Serializable,
AbstractLookup.Storage {
    private static final long serialVersionUID = 1L;
    private transient Node object = new Node(Object.class);
    private transient Map interfaces;
    private transient Map reg;

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.object);
        if (this.interfaces != null) {
            for (Map.Entry e : this.interfaces.entrySet()) {
                Class c = (Class)e.getKey();
                oos.writeObject(c.getName());
                Object o = e.getValue();
                if (!(o instanceof Collection) && !(o instanceof AbstractLookup.Pair)) {
                    throw new ClassCastException(String.valueOf(o));
                }
                oos.writeObject(o);
            }
        }
        oos.writeObject(null);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        String clazz;
        this.object = (Node)ois.readObject();
        this.interfaces = new WeakHashMap();
        ClassLoader l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        while ((clazz = (String)ois.readObject()) != null) {
            Object o = ois.readObject();
            if (!(o instanceof Collection) && !(o instanceof AbstractLookup.Pair)) {
                throw new ClassCastException(String.valueOf(o));
            }
            Class<?> c = Class.forName(clazz, false, l);
            this.interfaces.put(c, o);
        }
    }

    public boolean add(AbstractLookup.Pair item, Object transaction) {
        ArrayList affected = (ArrayList)transaction;
        Node node = InheritanceTree.registerClass(this.object, item);
        affected.add(node.getType());
        if (!node.assignItem(this, item)) {
            return false;
        }
        boolean registeredAsInterface = this.registerInterface(item, affected);
        return registeredAsInterface;
    }

    public void remove(AbstractLookup.Pair item, Object transaction) {
        ArrayList affected = (ArrayList)transaction;
        Node n = InheritanceTree.removeClass(this.object, item);
        if (n != null) {
            affected.add(n.getType());
        }
        this.removeInterface(item, affected);
    }

    public void retainAll(Map retain, Object transaction) {
        ArrayList notify = (ArrayList)transaction;
        this.retainAllInterface(retain, notify);
        this.retainAllClasses(this.object, retain, notify);
    }

    public Enumeration lookup(Class clazz) {
        if (clazz != null && clazz.isInterface()) {
            return this.searchInterface(clazz);
        }
        return this.searchClass(this.object, clazz);
    }

    public static boolean unsorted(Enumeration en) {
        return en instanceof NeedsSortEnum;
    }

    public void print(PrintStream out, boolean instances) {
        InheritanceTree.printNode(this.object, "", out, instances);
    }

    private static Node registerClass(Node n, AbstractLookup.Pair item) {
        if (!n.accepts(item)) {
            return null;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = n.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.registerClass(ch, item);
                if (result == null) continue;
                return result;
            }
        }
        return n;
    }

    private static Node removeClass(Node n, AbstractLookup.Pair item) {
        if (!n.accepts(item)) {
            return null;
        }
        if (n.items != null && n.items.remove(item)) {
            return n;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = n.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node result = InheritanceTree.removeClass(ch, item);
                if ((ch.items == null || ch.items.isEmpty()) && (ch.children == null || ch.children.isEmpty())) {
                    it.remove();
                }
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private Node classToNode(final Node n, final Class clazz) {
        if (!n.accepts(clazz)) {
            return null;
        }
        if (n.getType() == clazz) {
            return n;
        }
        if (n.children != null) {
            Node ch;
            Iterator it = n.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                Node found = this.classToNode(ch, clazz);
                if (found != null && ch.deserialized()) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class VerifyJob
                    implements AbstractLookup.ISE.Job {
                        private AbstractLookup.Pair[] pairs;
                        private boolean[] answers;

                        public VerifyJob(Collection items) {
                            if (items != null) {
                                this.pairs = items.toArray(new AbstractLookup.Pair[0]);
                            }
                        }

                        @Override
                        public void before() {
                            ch.deserialized();
                            if (this.pairs != null) {
                                this.answers = new boolean[this.pairs.length];
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    this.answers[i] = this.pairs[i].instanceOf(clazz);
                                }
                            }
                        }

                        @Override
                        public void inside() {
                            if (this.pairs != null) {
                                for (int i = 0; i < this.pairs.length; ++i) {
                                    if (!this.answers[i]) continue;
                                    ch.assignItem(InheritanceTree.this, this.pairs[i]);
                                    n.items.remove(this.pairs[i]);
                                }
                            }
                            if (n.children != null) {
                                HashMap<Class, Node> nodes = new HashMap<Class, Node>(n.children.size() * 3);
                                Iterator child = n.children.iterator();
                                while (child.hasNext()) {
                                    Node node = InheritanceTree.extractNode(child);
                                    Node prev = nodes.put(node.getType(), node);
                                    if (prev == null) continue;
                                    child.remove();
                                    nodes.put(node.getType(), prev);
                                    prev.markDeserialized();
                                    if (prev.children == null) {
                                        prev.children = node.children;
                                    } else if (node.children != null) {
                                        prev.children.addAll(node.children);
                                    }
                                    if (node.items == null) continue;
                                    for (AbstractLookup.Pair item : node.items) {
                                        prev.assignItem(InheritanceTree.this, item);
                                    }
                                }
                            }
                        }
                    }
                    VerifyJob verify = new VerifyJob(n.items);
                    try {
                        verify.before();
                    }
                    catch (AbstractLookup.ISE ex) {
                        ch.markDeserialized();
                        ex.registerJob(verify);
                        throw ex;
                    }
                    verify.inside();
                    found = this.classToNode(ch, clazz);
                }
                if (found == null) continue;
                return found;
            }
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class TwoJobs
        implements AbstractLookup.ISE.Job {
            private AbstractLookup.Pair[] pairs;
            private boolean[] answers;
            private Node newNode;

            TwoJobs() {
            }

            @Override
            public void before() {
                AbstractLookup.Pair[] arr = null;
                boolean[] boolArr = null;
                if (n.items != null) {
                    arr = new AbstractLookup.Pair[n.items.size()];
                    boolArr = new boolean[n.items.size()];
                    int i = 0;
                    Iterator it = n.items.iterator();
                    while (it.hasNext()) {
                        AbstractLookup.Pair item;
                        arr[i] = item = (AbstractLookup.Pair)it.next();
                        boolArr[i] = item.instanceOf(clazz);
                        ++i;
                    }
                }
                this.pairs = arr;
                this.answers = boolArr;
            }

            @Override
            public void inside() {
                if (this.pairs != null && !Arrays.equals(n.items.toArray(), this.pairs)) {
                    return;
                }
                this.internal();
            }

            public void internal() {
                Iterator it;
                ArrayList<Node> reparent = null;
                if (n.children == null) {
                    n.children = new ArrayList();
                } else {
                    Node r;
                    it = n.children.iterator();
                    while ((r = InheritanceTree.extractNode(it)) != null) {
                        if (!clazz.isAssignableFrom(r.getType())) continue;
                        if (reparent == null) {
                            reparent = new ArrayList<Node>();
                        }
                        reparent.add(r);
                        it.remove();
                    }
                }
                this.newNode = new Node(clazz);
                n.children.add(this.newNode);
                if (reparent != null) {
                    this.newNode.children = reparent;
                }
                if (n.items != null) {
                    it = n.items.iterator();
                    int i = 0;
                    while (it.hasNext()) {
                        AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                        if (this.answers[i]) {
                            it.remove();
                            this.newNode.assignItem(InheritanceTree.this, this.pairs[i]);
                        }
                        ++i;
                    }
                }
            }
        }
        TwoJobs j = new TwoJobs();
        try {
            j.before();
        }
        catch (AbstractLookup.ISE ex) {
            ex.registerJob(j);
            throw ex;
        }
        j.internal();
        return j.newNode;
    }

    private Enumeration searchClass(Node n, Class clazz) {
        if (clazz != null) {
            n = this.classToNode(n, clazz);
        }
        if (n == null) {
            return Enumerations.empty();
        }
        return InheritanceTree.nodeToEnum(n);
    }

    private boolean retainAllClasses(Node node, Map retain, Collection notify) {
        Iterator it;
        boolean retained = false;
        if (node.items != null && retain != null) {
            it = node.items.iterator();
            while (it.hasNext()) {
                AbstractLookup.Pair item = (AbstractLookup.Pair)it.next();
                AbstractLookup.Info n = (AbstractLookup.Info)retain.remove(item);
                if (n == null) {
                    it.remove();
                    retained = true;
                    continue;
                }
                if (item.getIndex() == n.index) continue;
                item.setIndex(null, n.index);
            }
            if (retained && notify != null) {
                notify.add(node.getType());
            }
        }
        if (node.children != null) {
            Node ch;
            it = node.children.iterator();
            while ((ch = InheritanceTree.extractNode(it)) != null) {
                boolean result = this.retainAllClasses(ch, retain, notify);
                if (!result) continue;
                it.remove();
            }
        }
        return retained && node.items.isEmpty() && (node.children == null || node.children.isEmpty());
    }

    private static Enumeration nodeToEnum(Node n) {
        if (n.children == null) {
            return n.items == null ? Enumerations.empty() : Collections.enumeration(n.items);
        }
        class DeepAndItems
        implements Enumerations.Processor {
            DeepAndItems() {
            }

            public Object process(Object obj, Collection toAdd) {
                Node n2 = (Node)obj;
                if (n2.children != null) {
                    toAdd.addAll(n2.children);
                }
                if (n2.items == null || n2.items.isEmpty()) {
                    return Enumerations.empty();
                }
                return Collections.enumeration(n2.items);
            }
        }
        Enumeration en = Enumerations.queue(Enumerations.singleton(n), new DeepAndItems());
        return new NeedsSortEnum(Enumerations.concat(en));
    }

    private boolean registerInterface(AbstractLookup.Pair item, Collection affected) {
        if (this.interfaces == null) {
            return true;
        }
        for (Map.Entry entry : this.interfaces.entrySet()) {
            Class iface = (Class)entry.getKey();
            if (!item.instanceOf(iface)) continue;
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.add(item)) {
                    return false;
                }
            } else {
                if (value.equals(item)) {
                    return false;
                }
                ArrayList<Object> ll = new ArrayList<Object>(3);
                ll.add(value);
                ll.add(item);
                entry.setValue(ll);
            }
            affected.add(iface);
        }
        return true;
    }

    private void removeInterface(AbstractLookup.Pair item, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            if (value instanceof Collection) {
                Collection set = (Collection)value;
                if (!set.remove(item)) continue;
                if (set.size() == 1) {
                    entry.setValue(set.iterator().next());
                }
                affected.add(entry.getKey());
                continue;
            }
            if (!value.equals(item)) continue;
            it.remove();
            affected.add(entry.getKey());
        }
    }

    private void retainAllInterface(Map retainItems, Collection affected) {
        if (this.interfaces == null) {
            return;
        }
        Iterator it = this.interfaces.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object value = entry.getValue();
            HashMap retain = new HashMap(retainItems);
            boolean multi = value instanceof Collection;
            Iterator<Object> elems = multi ? ((Collection)value).iterator() : Collections.singleton(value).iterator();
            boolean changed = false;
            boolean reordered = false;
            while (elems.hasNext()) {
                AbstractLookup.Pair p = (AbstractLookup.Pair)elems.next();
                AbstractLookup.Info n = (AbstractLookup.Info)retain.remove(p);
                if (n == null) {
                    if (multi) {
                        elems.remove();
                    }
                    changed = true;
                    continue;
                }
                if (p.getIndex() == n.index) continue;
                p.setIndex(null, n.index);
                reordered = true;
            }
            if (reordered && value instanceof List) {
                List l = (List)value;
                Collections.sort(l, ALPairComparator.DEFAULT);
            }
            if (!changed) continue;
            if (multi) {
                Collection c = (Collection)value;
                if (c.size() == 1) {
                    entry.setValue(c.iterator().next());
                }
            } else {
                it.remove();
            }
            affected.add(entry.getKey());
        }
    }

    private Enumeration searchInterface(Class clazz) {
        Object obj;
        if (this.interfaces == null) {
            this.interfaces = new WeakHashMap();
        }
        if ((obj = this.interfaces.get(clazz)) == null) {
            AbstractLookup.Pair one = null;
            ArrayList<AbstractLookup.Pair> items = null;
            Enumeration en = this.lookup(Object.class);
            while (en.hasMoreElements()) {
                AbstractLookup.Pair it = (AbstractLookup.Pair)en.nextElement();
                if (!it.instanceOf(clazz)) continue;
                if (one == null) {
                    one = it;
                    continue;
                }
                if (items == null) {
                    items = new ArrayList(3);
                    items.add(one);
                }
                items.add(it);
            }
            if (items == null && one != null) {
                this.interfaces.put(clazz, one);
                return Enumerations.singleton(one);
            }
            if (items == null) {
                items = new ArrayList<AbstractLookup.Pair>(2);
            }
            this.interfaces.put(clazz, items);
            return Collections.enumeration(items);
        }
        if (obj instanceof Collection) {
            return Collections.enumeration((Collection)obj);
        }
        return Enumerations.singleton(obj);
    }

    private static Node extractNode(Iterator it) {
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.get() == null) {
                it.remove();
                continue;
            }
            return n;
        }
        return null;
    }

    private static void printNode(Node n, String sp, PrintStream out, boolean instances) {
        int i;
        Class type = n.getType();
        out.print(sp);
        out.println("Node for: " + type + "\t" + (type == null ? null : type.getClassLoader()));
        if (n.items != null) {
            i = 0;
            for (AbstractLookup.Pair p : new ArrayList(n.items)) {
                out.print(sp);
                out.print("  item (" + i++ + "): ");
                out.print(p);
                out.print(" id: " + Integer.toHexString(System.identityHashCode(p)));
                out.print(" index: ");
                out.print(p.getIndex());
                if (instances) {
                    out.print(" I: " + p.getInstance());
                }
                out.println();
            }
        }
        if (n.children != null) {
            i = 0;
            for (Node ch : n.children) {
                InheritanceTree.printNode(ch, sp + "  ", out, instances);
            }
        }
    }

    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult newRef) {
        if (this.reg == null) {
            this.reg = new HashMap();
        }
        Class clazz = newRef.template.getType();
        this.lookup(clazz);
        return this.reg.put(clazz, newRef);
    }

    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template templ) {
        this.collectListeners(null, templ.getType());
        return this.reg == null ? null : (AbstractLookup.ReferenceToResult)this.reg.get(templ.getType());
    }

    public Object beginTransaction(int ensure) {
        return new ArrayList();
    }

    public void endTransaction(Object transaction, Set allAffectedResults) {
        ArrayList list = (ArrayList)transaction;
        if (list.size() == 1) {
            this.collectListeners(allAffectedResults, (Class)list.get(0));
        } else {
            Iterator it = list.iterator();
            while (it.hasNext()) {
                this.collectListeners(allAffectedResults, (Class)it.next());
            }
        }
    }

    private void collectListeners(Set allAffectedResults, Class c) {
        if (this.reg == null) {
            return;
        }
        while (c != null) {
            AbstractLookup.ReferenceToResult first = (AbstractLookup.ReferenceToResult)this.reg.get(c);
            AbstractLookup.ReferenceIterator it = new AbstractLookup.ReferenceIterator(first);
            while (it.next()) {
                AbstractLookup.R result = it.current().getResult();
                if (allAffectedResults == null) continue;
                allAffectedResults.add(result);
            }
            if (first != it.first()) {
                if (it.first() == null) {
                    this.reg.remove(c);
                } else {
                    this.reg.put(c, it.first());
                }
            }
            c = c.getSuperclass();
        }
        if (this.reg.isEmpty()) {
            this.reg = null;
        }
    }

    private static final class NeedsSortEnum
    implements Enumeration {
        private Enumeration en;

        public NeedsSortEnum(Enumeration en) {
            this.en = en;
        }

        public boolean hasMoreElements() {
            return this.en.hasMoreElements();
        }

        public Object nextElement() {
            return this.en.nextElement();
        }
    }

    private static final class R
    implements Serializable {
        static final long serialVersionUID = 1L;
        private static ClassLoader l;
        private String clazzName;
        private transient Class clazz;
        private ArrayList children;
        private ArrayList items;

        public R(Node n) {
            this.clazzName = n.getType().getName();
            this.children = n.children;
            this.items = n.items instanceof ArrayList || n.items == null ? (ArrayList)n.items : new ArrayList(n.items);
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            if (l == null) {
                l = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            }
            this.clazz = Class.forName(this.clazzName, false, l);
        }

        private Object readResolve() throws ObjectStreamException {
            Node n = new Node(this.clazz);
            n.children = this.children;
            n.items = this.items;
            n.markDeserialized();
            return n;
        }
    }

    static final class Node
    extends WeakReference
    implements Serializable {
        static final long serialVersionUID = 3L;
        public ArrayList children;
        public List items;

        public Node(Class clazz) {
            super(clazz);
        }

        public boolean deserialized() {
            if (this.items == null || this.items instanceof ArrayList) {
                return false;
            }
            this.items = this.items.isEmpty() ? null : new ArrayList(this.items);
            return true;
        }

        public void markDeserialized() {
            this.items = this.items == null ? Collections.EMPTY_LIST : Collections.synchronizedList(this.items);
        }

        public Class getType() {
            Class c = (Class)this.get();
            return c == null ? Void.TYPE : c;
        }

        public boolean accepts(Class clazz) {
            if (this.getType() == Object.class) {
                return true;
            }
            return this.getType().isAssignableFrom(clazz);
        }

        public boolean accepts(AbstractLookup.Pair item) {
            if (this.getType() == Object.class) {
                return true;
            }
            return item.instanceOf(this.getType());
        }

        public boolean assignItem(InheritanceTree tree, AbstractLookup.Pair item) {
            if (this.items == null || this.items == Collections.EMPTY_LIST) {
                this.items = new ArrayList();
                this.items.add(item);
                return true;
            }
            if (this.items.contains(item)) {
                int i = this.items.indexOf(item);
                AbstractLookup.Pair old = (AbstractLookup.Pair)this.items.get(i);
                if (old != item) {
                    item.setIndex(tree, old.getIndex());
                }
                this.items.remove(old);
                this.items.add(item);
                return false;
            }
            this.items.add(item);
            return true;
        }

        private Object writeReplace() {
            return new R(this);
        }

        public String toString() {
            return "Node for " + this.get();
        }
    }
}

