/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.openide.util.Lookup;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;

final class MetaInfServicesLookup
extends AbstractLookup {
    private static final boolean DEBUG = Boolean.getBoolean("org.openide.util.lookup.MetaInfServicesLookup.DEBUG");
    private static final Map knownInstances = new WeakHashMap();
    private final Set classes = new WeakSet();
    private final ClassLoader loader;

    public MetaInfServicesLookup() {
        this(MetaInfServicesLookup.class.getClassLoader());
    }

    public MetaInfServicesLookup(ClassLoader loader) {
        this.loader = loader;
        if (DEBUG) {
            System.err.println("Created: " + this);
        }
    }

    public String toString() {
        return "MetaInfServicesLookup[" + this.loader + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void beforeLookup(Lookup.Template t) {
        HashSet listeners;
        Class c = t.getType();
        MetaInfServicesLookup metaInfServicesLookup = this;
        synchronized (metaInfServicesLookup) {
            if (!this.classes.add(c)) {
                return;
            }
            LinkedHashSet arr = this.getPairsAsLHS();
            this.search(c, arr);
            listeners = this.setPairsAndCollectListeners(arr);
        }
        this.notifyCollectedListeners(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(Class clazz, Collection result) {
        Enumeration<URL> en;
        if (DEBUG) {
            System.err.println("Searching for " + clazz.getName() + " in " + clazz.getClassLoader() + " from " + this);
        }
        String res = "META-INF/services/" + clazz.getName();
        try {
            en = this.loader.getResources(res);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return;
        }
        ArrayList foundClasses = new ArrayList();
        ArrayList removeClasses = new ArrayList();
        boolean foundOne = false;
        while (en.hasMoreElements()) {
            if (!foundOne) {
                foundOne = true;
                Class<?> realMcCoy = null;
                try {
                    realMcCoy = this.loader.loadClass(clazz.getName());
                }
                catch (ClassNotFoundException cnfe) {
                    // empty catch block
                }
                if (realMcCoy != clazz) {
                    if (DEBUG) {
                        if (realMcCoy != null) {
                            System.err.println(clazz.getName() + " is not the real McCoy! Actually found it in " + realMcCoy.getClassLoader());
                        } else {
                            System.err.println(clazz.getName() + " could not be found in " + this.loader);
                        }
                    }
                    return;
                }
            }
            URL url = en.nextElement();
            Item currentItem = null;
            try {
                InputStream is = url.openStream();
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).startsWith("#position=")) {
                            if (currentItem == null) assert (false) : "Found line '" + line + "' but there is no item to associate it with!";
                            try {
                                currentItem.position = Integer.parseInt(line.substring(10));
                            }
                            catch (NumberFormatException e) {
                                e.printStackTrace();
                            }
                        }
                        if (currentItem != null) {
                            this.insertItem(currentItem, foundClasses);
                            currentItem = null;
                        }
                        if (line.length() == 0) continue;
                        boolean remove = false;
                        if (line.charAt(0) == '#') {
                            if (line.length() == 1 || line.charAt(1) != '-') continue;
                            remove = true;
                            line = line.substring(2);
                        }
                        Class<?> inst = null;
                        try {
                            inst = Class.forName(line, false, this.loader);
                        }
                        catch (ClassNotFoundException cnfe) {
                            if (remove) continue;
                            throw cnfe;
                        }
                        if (!clazz.isAssignableFrom(inst)) {
                            if (DEBUG) {
                                System.err.println("Not a subclass");
                            }
                            throw new ClassNotFoundException(inst.getName() + " not a subclass of " + clazz.getName());
                        }
                        if (remove) {
                            removeClasses.add(inst);
                            continue;
                        }
                        currentItem = new Item();
                        currentItem.clazz = inst;
                    }
                    if (currentItem == null) continue;
                    this.insertItem(currentItem, foundClasses);
                    currentItem = null;
                }
                finally {
                    is.close();
                }
            }
            catch (ClassNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (DEBUG) {
            System.err.println("Found impls of " + clazz.getName() + ": " + foundClasses + " and removed: " + removeClasses + " from: " + this);
        }
        foundClasses.removeAll(removeClasses);
        for (Item item : foundClasses) {
            if (removeClasses.contains(item.clazz)) continue;
            result.add(new P(item.clazz));
        }
    }

    private void insertItem(Item item, List list) {
        if (item.position == -1) {
            list.add(item);
            return;
        }
        int index = -1;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ++index;
            Item i = (Item)it.next();
            if (i.position == -1) {
                list.add(index, item);
                return;
            }
            if (i.position <= item.position) continue;
            list.add(index, item);
            return;
        }
        list.add(item);
    }

    private static final class P
    extends AbstractLookup.Pair {
        private Object object;

        public P(Class clazz) {
            this.object = clazz;
        }

        private Class clazz() {
            Object o = this.object;
            if (o instanceof Class) {
                return (Class)o;
            }
            if (o != null) {
                return o.getClass();
            }
            return Object.class;
        }

        public boolean equals(Object o) {
            if (o instanceof P) {
                return ((P)o).clazz().equals(this.clazz());
            }
            return false;
        }

        public int hashCode() {
            return this.clazz().hashCode();
        }

        protected boolean instanceOf(Class c) {
            return c.isAssignableFrom(this.clazz());
        }

        public Class getType() {
            return this.clazz();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getInstance() {
            Object o = this.object;
            if (o instanceof Class) {
                Object object = o;
                synchronized (object) {
                    try {
                        Class c = (Class)o;
                        Map map = knownInstances;
                        synchronized (map) {
                            o = knownInstances.get(c);
                        }
                        if (o == null) {
                            o = c.newInstance();
                            map = knownInstances;
                            synchronized (map) {
                                knownInstances.put(c, o);
                            }
                        }
                        this.object = o;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        this.object = null;
                    }
                }
            }
            return this.object;
        }

        public String getDisplayName() {
            return this.clazz().getName();
        }

        public String getId() {
            return this.clazz().getName();
        }

        protected boolean creatorOf(Object obj) {
            return obj == this.object;
        }
    }

    private static class Item {
        private Class clazz;
        private int position = -1;

        private Item() {
        }
    }
}

