/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

final class SimpleProxyLookup
extends Lookup {
    private Lookup.Provider provider;
    private Lookup delegate;
    private WeakHashMap results;

    SimpleProxyLookup(Lookup.Provider provider) {
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lookup checkLookup() {
        Lookup l = this.provider.getLookup();
        Iterator<Object> toCheck = null;
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (l != this.delegate) {
                this.delegate = l;
                if (this.results != null) {
                    toCheck = Arrays.asList(this.results.values().toArray()).iterator();
                }
            }
        }
        if (toCheck != null) {
            ArrayList evAndListeners = new ArrayList();
            Iterator<Object> it = toCheck;
            while (it.hasNext()) {
                Reference ref = (Reference)it.next();
                ProxyResult p = (ProxyResult)ref.get();
                if (p == null || !p.updateLookup(l)) continue;
                p.collectFires(evAndListeners);
            }
            it = evAndListeners.iterator();
            while (it.hasNext()) {
                LookupEvent ev = (LookupEvent)it.next();
                LookupListener ll = (LookupListener)it.next();
                ll.resultChanged(ev);
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result lookup(Lookup.Template template) {
        SimpleProxyLookup simpleProxyLookup = this;
        synchronized (simpleProxyLookup) {
            if (this.results == null) {
                this.results = new WeakHashMap();
            } else {
                ProxyResult p;
                Reference ref = (Reference)this.results.get(template);
                if (ref != null && (p = (ProxyResult)ref.get()) != null) {
                    return p;
                }
            }
            ProxyResult p = new ProxyResult(template);
            this.results.put(template, new WeakReference<ProxyResult>(p));
            return p;
        }
    }

    public Object lookup(Class clazz) {
        return this.checkLookup().lookup(clazz);
    }

    public Lookup.Item lookupItem(Lookup.Template template) {
        return this.checkLookup().lookupItem(template);
    }

    private final class WeakResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Result source;
        private Reference result;

        public WeakResult(ProxyResult r, Lookup.Result s) {
            this.result = new WeakReference<ProxyResult>(r);
            this.source = s;
        }

        protected void beforeLookup(Lookup.Template t) {
            ProxyResult r = (ProxyResult)this.result.get();
            if (r != null) {
                r.beforeLookup(t);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        protected void collectFires(Collection evAndListeners) {
            ProxyResult r = (ProxyResult)this.result.get();
            if (r != null) {
                r.collectFires(evAndListeners);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        public void addLookupListener(LookupListener l) {
            assert (false);
        }

        public void removeLookupListener(LookupListener l) {
            assert (false);
        }

        public Collection allInstances() {
            assert (false);
            return null;
        }

        public void resultChanged(LookupEvent ev) {
            ProxyResult r = (ProxyResult)this.result.get();
            if (r != null) {
                r.resultChanged(ev);
            } else {
                this.source.removeLookupListener(this);
            }
        }

        public Collection allItems() {
            assert (false);
            return null;
        }

        public Set allClasses() {
            assert (false);
            return null;
        }
    }

    private final class ProxyResult
    extends WaitableResult
    implements LookupListener {
        private Lookup.Template template;
        private Lookup.Result delegate;
        private EventListenerList listeners;
        private LookupListener lastListener;

        ProxyResult(Lookup.Template template) {
            this.template = template;
        }

        private Lookup.Result checkResult() {
            this.updateLookup(SimpleProxyLookup.this.checkLookup());
            return this.delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean updateLookup(Lookup l) {
            LookupListener removedListener;
            List oldPairs = this.delegate != null ? this.delegate.allItems() : null;
            ProxyResult proxyResult = this;
            synchronized (proxyResult) {
                if (this.delegate != null && this.lastListener != null) {
                    removedListener = this.lastListener;
                    this.delegate.removeLookupListener(this.lastListener);
                } else {
                    removedListener = null;
                }
            }
            Lookup.Result res = l.lookup(this.template);
            ProxyResult proxyResult2 = this;
            synchronized (proxyResult2) {
                if (removedListener == this.lastListener) {
                    this.delegate = res;
                    this.lastListener = new WeakResult(this, this.delegate);
                    this.delegate.addLookupListener(this.lastListener);
                }
            }
            if (oldPairs == null) {
                return false;
            }
            ArrayList newPairs = this.delegate.allItems();
            if (!(oldPairs instanceof List)) {
                oldPairs = oldPairs == Collections.EMPTY_SET ? Collections.EMPTY_LIST : new ArrayList(oldPairs);
            }
            if (!(newPairs instanceof List)) {
                newPairs = new ArrayList(newPairs);
            }
            return !oldPairs.equals(newPairs);
        }

        public synchronized void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                this.listeners = new EventListenerList();
            }
            this.listeners.add(LookupListener.class, l);
        }

        public synchronized void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(LookupListener.class, l);
            }
        }

        public Collection allInstances() {
            return this.checkResult().allInstances();
        }

        public Set allClasses() {
            return this.checkResult().allClasses();
        }

        public Collection allItems() {
            return this.checkResult().allItems();
        }

        protected void beforeLookup(Lookup.Template t) {
            Lookup.Result r = this.checkResult();
            if (r instanceof WaitableResult) {
                ((WaitableResult)r).beforeLookup(t);
            }
        }

        public void resultChanged(LookupEvent anEvent) {
            this.collectFires(null);
        }

        protected void collectFires(Collection evAndListeners) {
            EventListenerList l = this.listeners;
            if (l == null) {
                return;
            }
            Object[] listeners = l.getListenerList();
            if (listeners.length == 0) {
                return;
            }
            LookupEvent ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(listeners, ev, evAndListeners);
        }
    }
}

