/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private PipedOutputStream pos;
    private PipedInputStream pis;
    private OutputStreamWriter osw;

    public ReaderInputStream(Reader reader) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter(this.pos);
    }

    public ReaderInputStream(Reader reader, String encoding) throws IOException {
        this.reader = reader;
        this.pos = new PipedOutputStream();
        this.pis = new PipedInputStream(this.pos);
        this.osw = new OutputStreamWriter((OutputStream)this.pos, encoding);
    }

    @Override
    public int read() throws IOException {
        if (this.pis.available() > 0) {
            return this.pis.read();
        }
        int c = this.reader.read();
        if (c == -1) {
            return c;
        }
        this.osw.write(c);
        this.osw.flush();
        this.pos.flush();
        return this.pis.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && this.reader.ready(); ++i) {
            c = this.read();
            if (c == -1) {
                return i;
            }
            b[off + i] = (byte)c;
        }
        return i;
    }

    @Override
    public int available() throws IOException {
        int i = this.pis.available();
        if (i > 0) {
            return i;
        }
        if (this.reader.ready()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
        this.osw.close();
        this.pis.close();
    }
}

