/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import org.openthinclient.ldap.AttributeMapping;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.DiropLogger;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildMapping
extends AttributeMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Cardinality.class);
    private String filter;
    private final Class childType;
    private TypeMapping childMapping;

    public ChildMapping(String fieldName, String fieldType) throws ClassNotFoundException {
        super(fieldName, fieldType);
        this.childType = Class.forName(fieldType);
        if (!Object.class.isAssignableFrom(this.childType)) {
            throw new IllegalArgumentException("The field " + fieldName + " is not a subclass of Object");
        }
    }

    @Override
    protected void initPostLoad() {
        super.initPostLoad();
        TypeMapping child = this.type.getMapping().getMapping(this.childType);
        if (null == child) {
            throw new IllegalStateException(this + ": no mapping for peer type " + this.childType);
        }
        this.childMapping = child;
        child.addReferrer(this);
    }

    @Override
    public void hydrate(Object o, Attributes a, Transaction tx) throws DirectoryException {
    }

    @Override
    protected void cascadePostLoad(final Object parent, Transaction tx) throws DirectoryException {
        if (this.cardinality == Cardinality.MANY || this.cardinality == Cardinality.ONE_OR_MANY) {
            this.setValue(parent, Proxy.newProxyInstance(parent.getClass().getClassLoader(), new Class[]{Set.class}, new InvocationHandler(){
                private Object childSet;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (null == this.childSet) {
                        Transaction tx = new Transaction(ChildMapping.this.type.getMapping());
                        try {
                            DiropLogger.LOG.logReadComment("LAZY LOAD: children for {0}", ChildMapping.this.fieldName);
                            this.childSet = ChildMapping.this.loadChildren(parent, tx);
                            ChildMapping.this.setValue(parent, this.childSet);
                        }
                        finally {
                            tx.commit();
                        }
                    }
                    return method.invoke(this.childSet, args);
                }
            }));
        } else {
            this.setValue(parent, this.loadChildren(parent, tx));
        }
    }

    private Object loadChildren(Object parent, Transaction tx) throws DirectoryException {
        String dn = this.type.getDN(parent);
        Set set = this.childMapping.list(null != this.filter ? new Filter(this.filter, dn) : null, dn, null, tx);
        switch (this.cardinality) {
            case ONE: {
                if (set.size() == 0) {
                    logger.warn("No child for " + this + " with cardinality ONE found at " + dn + ", filter: " + this.filter);
                    return null;
                }
            }
            case ZERO_OR_ONE: {
                if (set.size() == 0) {
                    return null;
                }
                if (set.size() == 1) {
                    return set.iterator().next();
                }
                throw new DirectoryException("More than one child for " + this + " with cardinality ONE found at " + dn + ", filter: " + this.filter);
            }
            case ONE_OR_MANY: {
                if (set.size() != 0) break;
                throw new DirectoryException("No child for " + this + " with cardinality ONE_OR_MANY found at " + dn + ", filter: " + this.filter);
            }
        }
        return set;
    }

    @Override
    protected boolean checkNull(Attributes a) {
        return false;
    }

    @Override
    public void setCardinality(String cardinality) {
        super.setCardinality(cardinality);
        if (this.cardinality == Cardinality.ONE_OR_MANY || this.cardinality == Cardinality.MANY) {
            this.setFieldType(Set.class);
        }
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    protected void initNewInstance(Object instance) throws DirectoryException {
        if (this.cardinality == Cardinality.ONE || this.cardinality == Cardinality.ONE_OR_MANY) {
            Object v = this.type.getMapping().create(this.childType);
            if (this.cardinality == Cardinality.ONE_OR_MANY) {
                HashSet tmp = new HashSet();
                tmp.add(v);
                v = tmp;
            }
            this.setValue(instance, v);
        }
    }

    @Override
    public Object dehydrate(Object o, BasicAttributes a) throws DirectoryException {
        return null;
    }

    @Override
    protected void cascadePostSave(Object o, Transaction tx, DirContext ctx) throws DirectoryException {
        switch (this.cardinality) {
            case ONE: {
                Object child = this.getValue(o);
                if (null == child) {
                    throw new DirectoryException("No child for child mapping with cardinality ONE present");
                }
                this.save(o, child, tx);
                break;
            }
            case ZERO_OR_ONE: {
                this.save(o, this.getValue(o), tx);
                break;
            }
            case ONE_OR_MANY: {
                Set set = (Set)this.getValue(o);
                if (Proxy.isProxyClass(set.getClass())) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Still got the dynamic proxy for " + o);
                    break;
                }
                if (set.size() == 0) {
                    throw new DirectoryException("No child for child mapping with cardinality ONE_OR_MANY present");
                }
                this.save(o, set, tx);
                break;
            }
            default: {
                Set set = (Set)this.getValue(o);
                if (Proxy.isProxyClass(set.getClass())) {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug("Still got the dynamic proxy for " + o);
                    break;
                }
                this.save(o, set, tx);
            }
        }
    }

    @Override
    public void cascadeRDNChange(Object parent, String oldDN, String newDN, Transaction tx) throws DirectoryException, NamingException {
        switch (this.cardinality) {
            case ONE: 
            case ZERO_OR_ONE: {
                Object child = this.getValue(parent);
                this.childMapping.handleParentNameChange(child, oldDN, newDN, tx);
                break;
            }
            case ONE_OR_MANY: 
            case MANY: {
                Set children = (Set)this.getValue(parent);
                if (Proxy.isProxyClass(children.getClass())) {
                    this.cascadePostLoad(parent, tx);
                    break;
                }
                for (Object c : children) {
                    this.childMapping.handleParentNameChange(c, oldDN, newDN, tx);
                }
                break;
            }
        }
    }

    private void save(Object parent, Set children, Transaction tx) throws DirectoryException {
        String parentDNrelative;
        TypeMapping parentMapping = this.getParentMapping(parent);
        try {
            parentDNrelative = this.type.getDirectoryFacade().makeRelativeName(parentMapping.getDN(parent)).toString();
            String parentDNabsolute = this.type.getDirectoryFacade().makeAbsoluteName(parentDNrelative).toString();
        }
        catch (NamingException e) {
            throw new DirectoryException("Parent DN can't be turned into relative one", e);
        }
        Set existing = this.type.getMapping().list(this.childType, null != this.filter ? new Filter(this.filter, parentDNrelative) : null, parentDNrelative, null);
        HashSet missing = new HashSet();
        if (null != children) {
            missing.addAll(children);
        }
        Iterator i = missing.iterator();
        while (i.hasNext()) {
            if (!existing.remove(i.next())) continue;
            i.remove();
        }
        for (Object object : existing) {
            this.childMapping.delete(object, tx);
        }
        for (Object missingObject : missing) {
            this.childMapping.save(missingObject, parentDNrelative, tx);
        }
    }

    private void save(Object parent, Object child, Transaction tx) throws DirectoryException {
        TypeMapping parentMapping = this.getParentMapping(parent);
        String parentDN = parentMapping.getDN(parent);
        if (null == child) {
            Set set = this.type.getMapping().list(this.childType, null != this.filter ? new Filter(this.filter, parentDN) : null, parentDN, null);
            for (Object existingChild : set) {
                this.childMapping.delete(existingChild, tx);
            }
        } else {
            this.childMapping.save(child, parentDN, tx);
        }
    }

    private TypeMapping getParentMapping(Object parent) {
        TypeMapping parentMapping = this.type.getMapping().getMapping(parent.getClass(), this.type.getDirectoryFacade());
        if (null == parentMapping) {
            throw new IllegalStateException("Parent " + parent.getClass() + " for " + this + " is not mapped");
        }
        return parentMapping;
    }

    @Override
    public String toString() {
        return "[ChildMapping name=" + this.fieldName + ", cardinality=" + (Object)((Object)this.cardinality) + ", type=" + this.childType + "]";
    }
}

