/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import com.sun.jndi.ldap.LdapURL;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.LinkedList;
import javax.naming.NamingException;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.HTTPSchemaProvider;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.LDAPConnectionDescriptor;
import org.openthinclient.ldap.auth.UsernamePasswordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Realm
extends Profile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(Realm.class);
    private LDAPConnectionDescriptor lcd;
    private transient UserGroup administrators;
    private transient User readOnlyPrincipal;
    private transient LDAPDirectory directory;
    private transient boolean needRefresh;
    private transient SchemaProvider schemaProvider;
    private String schemaProviderName;
    private static short DEFAULT_SECONDARY_LDAPPORT = (short)389;
    private boolean isInitialized;

    public Realm() {
    }

    public Realm(LDAPConnectionDescriptor lcd) throws DirectoryException {
        this.lcd = lcd;
        this.setDn("ou=RealmConfiguration");
    }

    @Override
    public String toString() {
        String sb = new StringBuffer("[Realm url=").append(this.lcd != null ? this.lcd.getLDAPUrl() : "?").append(", description=").append(this.getDescription()).append("}]").toString();
        if (logger.isDebugEnabled()) {
            logger.debug("Realm: " + sb);
        }
        return new StringBuffer("[Realm url=").append(this.lcd != null ? this.lcd.getLDAPUrl() : "?").append(", description=").append(this.getDescription()).append("}]").toString();
    }

    public void setConnectionDescriptor(LDAPConnectionDescriptor lcd) {
        this.lcd = lcd;
    }

    public LDAPDirectory getDirectory() throws DirectoryException {
        if (null == this.directory) {
            this.directory = LDAPDirectory.openRealm(this);
        }
        return this.directory;
    }

    public void closeDirectory() {
        this.directory = null;
    }

    public void refresh() throws DirectoryException {
        this.needRefresh = false;
        this.directory = null;
        this.getDirectory().refresh(this);
    }

    public void ensureInitialized() {
        if (!this.isInitialized) {
            try {
                this.refresh();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        this.isInitialized = true;
    }

    public LDAPConnectionDescriptor getConnectionDescriptor() {
        return this.lcd;
    }

    public LDAPConnectionDescriptor createSecondaryConnectionDescriptor() throws DirectoryException {
        LDAPConnectionDescriptor secLcd = new LDAPConnectionDescriptor();
        String urlString = this.getValue("Directory.Secondary.LDAPURLs");
        try {
            LdapURL ldapUrl = new LdapURL(urlString);
            secLcd.setProviderType(LDAPConnectionDescriptor.ProviderType.SUN);
            secLcd.setHostname(ldapUrl.getHost());
            short ldapPort = (short)ldapUrl.getPort();
            if (-1 == ldapPort) {
                ldapPort = DEFAULT_SECONDARY_LDAPPORT;
            }
            secLcd.setPortNumber(ldapPort);
            secLcd.setBaseDN(ldapUrl.getDN());
            String principal = this.getValue("Directory.Secondary.ReadOnly.Principal");
            String secret = this.getValue("Directory.Secondary.ReadOnly.Secret");
            if (null != principal) {
                secLcd.setCallbackHandler(new UsernamePasswordHandler(principal, secret));
                secLcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.SIMPLE);
            } else {
                secLcd.setAuthenticationMethod(LDAPConnectionDescriptor.AuthenticationMethod.NONE);
            }
            secLcd.setReadOnly(true);
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return secLcd;
    }

    public void setNeedsRefresh() {
        this.needRefresh = true;
    }

    @Override
    public boolean containsValue(String key) {
        this.checkRefresh();
        return super.containsValue(key);
    }

    private void checkRefresh() {
        if (this.needRefresh) {
            try {
                this.refresh();
            }
            catch (DirectoryException e) {
                throw new RuntimeException("Unexpected exception during realm refresh", e);
            }
        }
    }

    @Override
    public String getDefiningProfile(String path, boolean excludeThis) {
        this.checkRefresh();
        return super.getDefiningProfile(path, excludeThis);
    }

    @Override
    public String getOverriddenValue(String key) {
        this.checkRefresh();
        return super.getOverriddenValue(key);
    }

    @Override
    public Schema getSchema(Realm realm) throws SchemaLoadingException {
        this.checkRefresh();
        return super.getSchema(realm);
    }

    @Override
    public String getValue(String key) {
        this.checkRefresh();
        return super.getValue(key);
    }

    @Override
    public boolean inherits(String key) {
        this.checkRefresh();
        return super.inherits(key);
    }

    @Override
    public void removeValue(String key) {
        this.checkRefresh();
        super.removeValue(key);
    }

    @Override
    public void setSchema(Schema schema) {
        this.checkRefresh();
        super.setSchema(schema);
    }

    @Override
    public void setValue(String path, String value) {
        this.checkRefresh();
        super.setValue(path, value);
    }

    public UserGroup getAdministrators() {
        if (null == this.administrators) {
            this.administrators = new UserGroup();
            this.administrators.setName("administrators");
        }
        return this.administrators;
    }

    public void setAdministrators(UserGroup administrators) {
        this.administrators = administrators;
    }

    public SchemaProvider getSchemaProvider() throws SchemaLoadingException {
        if (null == this.schemaProvider) {
            this.schemaProvider = this.createSchemaProvider();
        }
        return this.schemaProvider;
    }

    public void setSchemaProviderName(String providerName) {
        this.schemaProviderName = providerName;
    }

    public String getSchemaProviderName() {
        return this.schemaProviderName;
    }

    public void setSchemaProvider(SchemaProvider schemaProvider) {
        this.schemaProvider = schemaProvider;
    }

    private SchemaProvider createSchemaProvider() throws SchemaLoadingException {
        LinkedList<String> schemaProviderHosts = new LinkedList<String>();
        String schemaProviderHost = this.getValue("Serversettings.SchemaProviderName");
        if (null == schemaProviderHost) {
            schemaProviderHost = this.lcd.getHostname();
        }
        if (null != schemaProviderHost) {
            schemaProviderHosts.add(schemaProviderHost);
        }
        schemaProviderHosts.add("localhost");
        for (String host : schemaProviderHosts) {
            if (host == null) continue;
            try {
                HTTPSchemaProvider provider = new HTTPSchemaProvider(host);
                if (provider.checkAccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using " + host);
                    }
                    return provider;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Can't use " + host);
                }
            }
            catch (MalformedURLException e) {
                logger.error("Invalid server URL for " + host, (Throwable)e);
            }
            if (!logger.isDebugEnabled() || host != "localhost") continue;
            logger.warn("No usable servers found - falling back to local schemas");
        }
        throw new SchemaLoadingException("Schema wasn't found: schema provider could not be determined");
    }

    @Override
    public String getName() {
        return "RealmConfiguration";
    }

    public User getReadOnlyPrincipal() {
        if (null == this.readOnlyPrincipal) {
            this.readOnlyPrincipal = new User();
            this.readOnlyPrincipal.setName("roPrincipal");
            this.readOnlyPrincipal.setSn("Read Only User");
        }
        return this.readOnlyPrincipal;
    }

    public void setReadOnlyPrincipal(User readOnlyPrincipal) {
        this.readOnlyPrincipal = readOnlyPrincipal;
    }

    public void fakePropertyChange() {
        this.firePropertyChange("user", "old", "new");
    }

    public void removeSchemaProvider() {
        this.schemaProvider = null;
    }

    @Override
    protected String getSchemaName() {
        return "realm";
    }
}

