/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.castor.util.Base64Encoder;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.UserGroup;

public class User
extends DirectoryObject
implements AssociatedObjectsProvider {
    private static final long serialVersionUID = 1L;
    private Set<UserGroup> userGroups;
    private Set<ApplicationGroup> applicationGroups;
    private Set<Application> applications;
    private Set<Printer> printers;
    private Location location;
    private String sn;
    private String givenName;
    private byte[] userPassword;
    private String newPassword = "";
    private String verifyPassword = "";

    public Set<ApplicationGroup> getApplicationGroups() {
        return this.applicationGroups;
    }

    public void setApplicationGroups(Set<ApplicationGroup> applicationGroups) {
        this.applicationGroups = applicationGroups;
        this.firePropertyChange("applicationGroups", null, applicationGroups);
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Set<Application> applications) {
        this.applications = applications;
        this.firePropertyChange("applications", null, applications);
    }

    public void setLocation(Location location) {
        this.location = location;
        this.firePropertyChange("location", null, location);
    }

    public Set<Printer> getPrinters() {
        return this.printers;
    }

    public void setPrinters(Set<Printer> printers) {
        this.printers = printers;
        this.firePropertyChange("printers", null, printers);
    }

    public Set<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(Set<UserGroup> userGroups) {
        this.userGroups = userGroups;
        this.firePropertyChange("userGroups", null, userGroups);
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
        this.firePropertyChange("givenName", null, givenName);
    }

    public String getSn() {
        if (null == this.sn) {
            this.sn = this.getName();
        }
        return this.sn;
    }

    public void setSn(String sn) {
        this.sn = sn;
        this.firePropertyChange("sn", null, sn);
    }

    @Override
    public Map<Class, Set<? extends DirectoryObject>> getAssociatedObjects() {
        HashMap<Class, Set<? extends DirectoryObject>> assocObjects = new HashMap<Class, Set<? extends DirectoryObject>>();
        assocObjects.put(Application.class, this.applications);
        assocObjects.put(ApplicationGroup.class, this.applicationGroups);
        assocObjects.put(Printer.class, this.printers);
        assocObjects.put(UserGroup.class, this.userGroups);
        return assocObjects;
    }

    @Override
    public void setAssociatedObjects(Class subgroupClass, Set<? extends DirectoryObject> subgroups) {
        if (subgroupClass.equals(Application.class)) {
            this.setApplications(subgroups);
        }
        if (subgroupClass.equals(ApplicationGroup.class)) {
            this.setApplicationGroups(subgroups);
        }
        if (subgroupClass.equals(Printer.class)) {
            this.setPrinters(subgroups);
        }
        if (subgroupClass.equals(UserGroup.class)) {
            this.setUserGroups(subgroups);
        }
    }

    public byte[] getUserPassword() {
        return this.userPassword;
    }

    public void setUserPassword(byte[] userPassword) {
        this.userPassword = userPassword;
    }

    public String getNewPassword() {
        return this.newPassword;
    }

    public void setNewPassword(String password) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            digest.update(password.getBytes());
            String encrypted = "{MD5}" + new String(Base64Encoder.encode((byte[])digest.digest()));
            this.setUserPassword(encrypted.getBytes());
            this.newPassword = password;
            this.firePropertyChange("newPassword", "", password);
            this.firePropertyChange("password", new byte[0], this.getUserPassword());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Can't encrypt user's password", e);
        }
    }

    public String getVerifyPassword() {
        return this.verifyPassword;
    }

    public void setVerifyPassword(String verifyPassword) {
        this.verifyPassword = verifyPassword;
        this.firePropertyChange("verifyPassword", "", verifyPassword);
    }

    public Location getLocation() {
        return this.location;
    }
}

