/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.service;

import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.service.AbstractLDAPService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.Filter;
import org.openthinclient.ldap.TypeMapping;

public class DefaultLDAPLocationService
extends AbstractLDAPService<Location>
implements LocationService {
    public DefaultLDAPLocationService(RealmService realmService) {
        super(Location.class, realmService);
    }

    @Override
    public Location findByName(String name) {
        return this.withAllReams(realm -> {
            try {
                return realm.getDirectory().list(Location.class, new Filter("(&(l={0}))", name), TypeMapping.SearchScope.SUBTREE).stream();
            }
            catch (DirectoryException e) {
                throw new RuntimeException(e);
            }
        }).findFirst().orElse(null);
    }
}

