/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model.util;

import org.openthinclient.common.model.Profile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.PropertySource;

public interface ConfigProperty<T> {
    public String getPropertyName();

    public T get(Profile var1);

    public T get(PropertySource<?> var1);

    public void set(Profile var1, T var2);

    public static class EnumConfig<T extends Enum<T>>
    implements ConfigProperty<T> {
        private static final Logger LOGGER = LoggerFactory.getLogger(EnumConfig.class);
        private final String propertyName;
        private final Class<T> enumClass;
        private final T defaultValue;

        public EnumConfig(String propertyName, Class<T> enumClass, T defaultValue) {
            this.propertyName = propertyName;
            this.enumClass = enumClass;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public T get(Profile profile) {
            return this.decode(profile.getValue(this.propertyName));
        }

        private T decode(Object value) {
            if (value == null) {
                return this.defaultValue;
            }
            if (this.enumClass.isAssignableFrom(value.getClass())) {
                return (T)((Enum)value);
            }
            String s = !(value instanceof String) ? value.toString() : (String)value;
            try {
                return Enum.valueOf(this.enumClass, s);
            }
            catch (Exception e) {
                LOGGER.error("Incorrect value specified for property " + this.propertyName + ". Value: " + s);
                return this.defaultValue;
            }
        }

        @Override
        public T get(PropertySource<?> propertySource) {
            return this.decode(propertySource.getProperty(this.propertyName));
        }

        @Override
        public void set(Profile profile, T value) {
            profile.setValue(this.propertyName, ((Enum)value).name());
        }
    }

    public static class StringConfig
    implements ConfigProperty<String> {
        private final String propertyName;

        public StringConfig(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public String get(Profile profile) {
            return profile.getValue(this.propertyName);
        }

        @Override
        public String get(PropertySource<?> propertySource) {
            return null;
        }

        @Override
        public void set(Profile profile, String value) {
            profile.setValue(this.propertyName, value);
        }
    }
}

