/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.lang.reflect.Method;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.ldap.Cardinality;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.ldap.Transaction;
import org.openthinclient.ldap.TypeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeMapping
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(AttributeMapping.class);
    protected final String fieldName;
    private Class fieldType;
    private Method getMethod;
    private String getMethodName;
    private Method setMethod;
    private String setMethodName;
    protected TypeMapping type;
    protected Cardinality cardinality = Cardinality.MANY;

    public AttributeMapping(String fieldName, String fieldType) throws ClassNotFoundException {
        this.fieldName = fieldName;
        this.setFieldType(Class.forName(fieldType));
    }

    protected void cascadeDelete(Name targetName, Transaction tx) throws DirectoryException {
    }

    protected void cascadePostLoad(Object o, Transaction tx) throws DirectoryException {
    }

    protected void cascadePostSave(Object o, Transaction tx, DirContext ctx) throws DirectoryException {
    }

    public void cascadeRDNChange(Object o, String oldDN, String newDN, Transaction tx) throws DirectoryException, NamingException {
    }

    protected boolean checkNull(Attributes a) {
        return null == a.get(this.fieldName);
    }

    public Object dehydrate(Object o, BasicAttributes a) throws DirectoryException, NamingException {
        if (logger.isDebugEnabled()) {
            logger.debug("dehydrating " + this.fieldName + " for instance of " + o.getClass());
        }
        try {
            Object v = this.getValue(o);
            return this.valueToAttributes(a, v);
        }
        catch (Exception e) {
            throw new DirectoryException("Can't read attribute from object", e);
        }
    }

    protected Object valueToAttributes(BasicAttributes a, Object v) {
        if (null != v) {
            if (this.fieldType.equals(String.class)) {
                if (((String)v).length() > 0) {
                    a.put(this.fieldName, v);
                }
            } else if (this.fieldType.equals(byte[].class)) {
                if (((byte[])v).length > 0) {
                    a.put(this.fieldName, v);
                }
            } else {
                a.put(this.fieldName, v.toString());
            }
        }
        return v;
    }

    protected Class getFieldType() {
        return this.fieldType;
    }

    protected Method getGetter() throws NoSuchMethodException {
        if (null == this.getMethod) {
            if (null == this.getMethodName) {
                this.getMethodName = "get" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
            }
            this.getMethod = this.getMethod(this.type.getMappedType(), this.getMethodName, new Class[0]);
        }
        return this.getMethod;
    }

    protected Method getMethod(Class targetClass, String methodName, Class[] parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException firstException = null;
        while (null != targetClass) {
            try {
                return targetClass.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (null == firstException) {
                    firstException = e;
                }
                targetClass = targetClass.getSuperclass();
            }
        }
        throw firstException;
    }

    protected Method getSetter() throws NoSuchMethodException {
        if (null == this.setMethod) {
            if (null == this.setMethodName) {
                this.setMethodName = "set" + this.fieldName.substring(0, 1).toUpperCase() + this.fieldName.substring(1);
            }
            this.setMethod = this.getMethod(this.type.getMappedType(), this.setMethodName, new Class[]{this.getFieldType()});
        }
        return this.setMethod;
    }

    protected Object getValue(Object o) throws DirectoryException {
        try {
            return this.getGetter().invoke(o, new Object[0]);
        }
        catch (Exception e) {
            throw new DirectoryException("Can't get value for " + this, e);
        }
    }

    public void hydrate(Object o, Attributes a, Transaction tx) throws DirectoryException {
        if (logger.isDebugEnabled()) {
            logger.debug("hydrating " + this + " for object of type " + o.getClass() + " from " + a);
        }
        if (this.checkNull(a)) {
            return;
        }
        try {
            this.setValue(o, this.valueFromAttributes(a, o, tx));
        }
        catch (DirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DirectoryException("Can't hydrate attribute " + this.fieldName, e);
        }
    }

    protected void initNewInstance(Object instance) throws DirectoryException {
    }

    protected void initPostLoad() {
    }

    protected void setFieldType(Class fieldType) {
        this.fieldType = fieldType;
        this.setMethod = null;
        this.getMethod = null;
    }

    public void setGetMethod(String getMethodName) {
        this.getMethodName = getMethodName;
    }

    public void setSetMethod(String setMethodName) {
        this.setMethodName = setMethodName;
    }

    public void setTypeMapping(TypeMapping type) {
        this.type = type;
    }

    Object setValue(Object o, Object value) throws DirectoryException {
        try {
            return this.getSetter().invoke(o, value);
        }
        catch (Exception e) {
            throw new DirectoryException("Can't set value for " + this, e);
        }
    }

    public String toString() {
        return "[AttributeMapping name=" + this.fieldName + " type=" + this.fieldType + "]";
    }

    protected Object valueFromAttributes(Attributes a, Object o, Transaction tx) throws NamingException, DirectoryException {
        if (this.fieldName.equalsIgnoreCase("cn")) {
            LdapName dn = new LdapName(((DirectoryObject)o).getDn());
            Rdn rdn = dn.getRdn(dn.size() - 1);
            return rdn.getValue();
        }
        Attribute attribute = a.get(this.fieldName);
        if (null != attribute) {
            Object v = attribute.get();
            if (null != v && this.fieldType.equals(Integer.class)) {
                try {
                    v = new Integer(v.toString());
                }
                catch (NumberFormatException e) {
                    logger.error("Can't convert this value to an Integer: " + v.toString());
                    v = null;
                }
            }
            return v;
        }
        return null;
    }

    protected void cascadePreSave(Object o, Transaction tx) throws DirectoryException {
    }

    protected AttributeMapping clone() throws CloneNotSupportedException {
        return (AttributeMapping)super.clone();
    }

    public void setCardinality(String cardinality) {
        this.cardinality = Cardinality.valueOf(cardinality);
    }

    protected String getFieldName() {
        return this.fieldName;
    }

    protected TypeMapping getTypeMapping() {
        return this.type;
    }
}

