/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.io.IOException;
import java.io.Serializable;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.openthinclient.ldap.Mapping;
import org.openthinclient.ldap.SecondLevelCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheSecondLevelCache
implements SecondLevelCache {
    private static final Logger logger = LoggerFactory.getLogger(EhCacheSecondLevelCache.class);
    private Cache cache;

    public EhCacheSecondLevelCache() {
        try {
            if (CacheManager.getInstance().cacheExists("mapping")) {
                this.cache = CacheManager.getInstance().getCache("mapping");
            } else {
                this.cache = new Cache("mapping", 5000, false, false, 120L, 120L);
                CacheManager.getInstance().addCache(this.cache);
            }
        }
        catch (CacheException e) {
            logger.error("Can't create cache. Caching is disabled", (Throwable)e);
        }
    }

    @Override
    public Attributes getEntry(Name name) {
        if (null == this.cache || Mapping.disableCache) {
            return null;
        }
        try {
            Element element = this.cache.get((Serializable)name);
            if (null != element && logger.isDebugEnabled()) {
                logger.debug("Global cache hit for " + name);
            }
            return (Attributes)(null != element ? element.getValue() : null);
        }
        catch (Throwable e) {
            logger.warn("Can't get from cache", e);
            return null;
        }
    }

    @Override
    public boolean purgeEntry(Name name) throws IllegalStateException {
        if (null != this.cache) {
            return this.cache.remove((Serializable)name);
        }
        return false;
    }

    @Override
    public void putEntry(Name name, Attributes a) {
        if (null != this.cache) {
            this.cache.put(new Element((Serializable)name, (Serializable)a));
            if (logger.isDebugEnabled()) {
                logger.debug("Caching entry for " + name);
            }
        }
    }

    @Override
    public void clear() throws IllegalStateException, IOException {
        if (null != this.cache) {
            this.cache.removeAll();
        }
    }
}

