/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Filter {
    private static final Pattern SHIFT_PATTERN = Pattern.compile("(.*?)(?:\\{(\\d+)\\}(.*?))*");
    private String expression;
    private Object[] args;

    public Filter(String expression, Object ... args) {
        this.expression = expression;
        this.args = args;
    }

    public String getExpression(int argumentOffset) {
        if (argumentOffset == 0) {
            return this.expression;
        }
        Matcher m = SHIFT_PATTERN.matcher(this.expression);
        assert (m.matches()) : "SHIFT_PATTERN doesn't match";
        int groupCount = m.groupCount();
        StringBuffer sb = new StringBuffer(m.group(1));
        int i = 2;
        while (i <= groupCount) {
            int groupNumber = Integer.parseInt(m.group(i));
            sb.append("{").append(groupNumber + argumentOffset).append("}");
            if (++i > groupCount) continue;
            sb.append(m.group(i));
            ++i;
        }
        return sb.toString();
    }

    public void fillArguments(Object[] target, int argumentOffset) {
        System.arraycopy(this.args, 0, target, argumentOffset, this.args.length);
    }

    public Object[] getArgs() {
        return this.args;
    }

    public int getArgumentCount() {
        return this.args.length;
    }
}

