/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.ldap;

import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger logger = LoggerFactory.getLogger(Util.class);

    public static void deleteRecursively(DirContext ctx, Name targetName) throws NamingException {
        Util.deleteRecursively(ctx, targetName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRecursively(DirContext ctx, Name targetName, String skipNameByRegex) throws NamingException {
        try (NamingEnumeration<NameClassPair> children = ctx.list(targetName);){
            while (children.hasMore()) {
                NameClassPair child = children.next();
                if (null != skipNameByRegex && child.getName().matches(skipNameByRegex)) continue;
                targetName.add(child.getName());
                Util.deleteRecursively(ctx, targetName, skipNameByRegex);
                targetName.remove(targetName.size() - 1);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("destroySubcontext: " + targetName);
        }
        try {
            ctx.destroySubcontext(targetName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean hasObjectClass(DirContext schema, String className) throws NamingException {
        SearchControls sc = new SearchControls();
        sc.setSearchScope(0);
        try {
            schema.list("ClassDefinition/" + className);
            return true;
        }
        catch (NameNotFoundException e) {
            return false;
        }
    }
}

