/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.meta;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.openthinclient.meta.PackageMetadata;

public class PackageMetadataReader {
    private final JAXBContext context;

    public PackageMetadataReader() {
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{PackageMetadata.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException("JAXB initialization failed", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PackageMetadata read(Path file) {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            PackageMetadata packageMetadata = this.read(in);
            return packageMetadata;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PackageMetadata read(InputStream in) {
        return this.read(new StreamSource(in));
    }

    public PackageMetadata read(Source source) {
        try {
            JAXBElement element = this.context.createUnmarshaller().unmarshal(source, PackageMetadata.class);
            return (PackageMetadata)element.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Package Metadata parsing failed", e);
        }
    }
}

