/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.AssociatedObjectsProvider;
import org.openthinclient.common.model.ClientGroup;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;

public class Client
extends ClientMetaData
implements AssociatedObjectsProvider {
    private static final long serialVersionUID = 1L;
    private Set<ApplicationGroup> applicationGroups;
    private Set<Application> applications;
    private Set<Printer> printers;
    private Set<Device> devices;
    private Set<ClientGroup> clientGroups;
    private HardwareType hardwareType;

    public Set<ApplicationGroup> getApplicationGroups() {
        return this.applicationGroups;
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public void setApplicationGroups(Set<ApplicationGroup> applicationGroups) {
        this.applicationGroups = applicationGroups;
    }

    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }

    public void setHardwareType(HardwareType hardwareType) {
        this.hardwareType = hardwareType;
        this.firePropertyChange("hardwareType", null, hardwareType);
    }

    public HardwareType getHardwareType() {
        return this.hardwareType;
    }

    public Set<ClientGroup> getClientGroups() {
        return this.clientGroups;
    }

    public void setClientGroups(Set<ClientGroup> clientGroups) {
        this.clientGroups = clientGroups;
    }

    @Deprecated
    public void setHwTypes(Set<HardwareType> hardwareType) {
        this.hardwareType = hardwareType.size() > 0 ? hardwareType.iterator().next() : null;
    }

    @Deprecated
    public Set<HardwareType> getHwTypes() {
        HashSet<HardwareType> set = new HashSet<HardwareType>();
        if (null != this.hardwareType) {
            set.add(this.hardwareType);
        }
        return set;
    }

    @Override
    public String toString() {
        return String.format("[Client %s, MAC=%s, IP=%s, hwtype=%s]", this.getName(), this.macAddress, this.ipHostNumber, this.hardwareType);
    }

    public Set<Printer> getPrinters() {
        return this.printers;
    }

    public void setPrinters(Set<Printer> printers) {
        this.printers = printers;
        this.firePropertyChange("printers", null, printers);
    }

    public Set<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Set<Device> devices) {
        this.devices = devices;
        this.firePropertyChange("devices", null, devices);
    }

    @Override
    public Map<Class, Set<? extends DirectoryObject>> getAssociatedObjects() {
        HashMap<Class, Set<? extends DirectoryObject>> assocObjects = new HashMap<Class, Set<? extends DirectoryObject>>();
        assocObjects.put(Application.class, this.applications);
        assocObjects.put(ApplicationGroup.class, this.applicationGroups);
        assocObjects.put(ClientGroup.class, this.clientGroups);
        assocObjects.put(Printer.class, this.printers);
        assocObjects.put(Device.class, this.devices);
        return assocObjects;
    }

    @Override
    public void setAssociatedObjects(Class subgroupClass, Set<? extends DirectoryObject> subgroups) {
        if (subgroupClass.equals(Application.class)) {
            this.setApplications(subgroups);
        }
        if (subgroupClass.equals(ApplicationGroup.class)) {
            this.setApplicationGroups(subgroups);
        }
        if (subgroupClass.equals(ClientGroup.class)) {
            this.setClientGroups(subgroups);
        }
        if (subgroupClass.equals(Printer.class)) {
            this.setPrinters(subgroups);
        }
        if (subgroupClass.equals(Device.class)) {
            this.setDevices(subgroups);
        }
    }

    @Override
    protected Profile[] getInheritedProfiles() {
        return new Profile[]{this.hardwareType, this.location, this.getRealm()};
    }
}

