/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.common.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.openthinclient.common.model.Realm;

public abstract class DirectoryObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String dn;
    private String name;
    private String description;
    private transient Realm realm;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public boolean equals(Object obj) {
        boolean ret = null != obj && this.getClass().equals(obj.getClass()) && this.dn != null && this.dn.equals(((DirectoryObject)obj).getDn());
        return ret;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ (null != this.dn ? this.dn.hashCode() : 28764721);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        String oldDescription = this.description;
        this.description = description;
        this.firePropertyChange("description", oldDescription, description);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        this.firePropertyChange("name", oldName, name);
    }

    public String toString() {
        return String.format("[%s %s]", this.getClass().getSimpleName(), this.getName());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.pcs == null || oldValue != null && newValue != null && oldValue.equals(newValue)) {
            return;
        }
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }
}

