/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.meta;

import com.google.common.base.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.stream.Stream;
import org.openthinclient.meta.Bookmark;
import org.openthinclient.meta.PackageMetadata;
import org.openthinclient.meta.PackageMetadataReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger(PackageMetadataManager.class);
    private final Path baseDirectory;
    private final Path managerHomeRoot;
    private final PackageMetadataReader reader;

    public PackageMetadataManager(Path baseDirectory, Path managerHomeRoot) {
        this.baseDirectory = baseDirectory;
        this.managerHomeRoot = managerHomeRoot;
        this.reader = new PackageMetadataReader();
    }

    public Stream<PackageMetadata> getMetadata() {
        Stream<Path> files;
        try {
            files = Files.list(this.baseDirectory);
        }
        catch (IOException e) {
            LOG.error("Failed to list contents from the metadata directory", (Throwable)e);
            return Stream.empty();
        }
        return files.filter(this::isPackageMetadataFile).map(this::parsePackageMetadataFile).filter(Objects::nonNull);
    }

    private PackageMetadata parsePackageMetadataFile(Path p) {
        try {
            return this.reader.read(p);
        }
        catch (Exception e) {
            LOG.error("Failed to parse " + p.toString(), (Throwable)e);
            return null;
        }
    }

    public Stream<Bookmark> getBookmarks() {
        return this.getMetadata().flatMap(m -> m.getBookmarks().stream()).filter(bookmark -> {
            if (Strings.isNullOrEmpty((String)bookmark.getPath())) {
                LOG.error("Ignoring bookmark entry without valid path");
                return false;
            }
            return true;
        });
    }

    private boolean isPackageMetadataFile(Path p) {
        return Files.isRegularFile(p, new LinkOption[0]) && p.getFileName().toString().endsWith(".meta.xml");
    }
}

