/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openthinclient.common.directory.LDAPDirectory;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.LdifActionProgressBar;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.DirectoryEntryNode;
import org.openthinclient.ldap.DirectoryException;

public class HTTPLdifImportAction {
    private static final Logger logger = Logger.getLogger(HTTPLdifImportAction.class);
    private static URL baseURL;
    private final String DEFAULT_FOLDERNAME = "ldif";
    private static boolean enableAsk;
    private Hashtable<String, Integer> allHashs = new Hashtable();
    private Set<String> allNewNames = new HashSet<String>();

    public HTTPLdifImportAction(String hostname) throws MalformedURLException {
        baseURL = new URL("http", hostname, 8080, "/openthinclient/files/ldif/");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using ldif base url: " + baseURL));
        }
    }

    private void makeNewBaseUrl(String hostname, String foldername) throws MalformedURLException {
        baseURL = new URL("http", hostname, 8080, "/openthinclient/files/" + foldername + "/");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Using ldif base url: " + baseURL));
        }
    }

    private boolean checkAccess() {
        try {
            URLConnection openConnection = baseURL.openConnection();
            String contentType = openConnection.getContentType();
            return contentType.startsWith("text/plain;");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Set<String> getAllFilenames() throws IOException {
        int c;
        InputStream in = baseURL.openStream();
        String input = "";
        while ((c = in.read()) != -1) {
            input = input + (char)c;
        }
        BufferedReader reader = new BufferedReader(new StringReader(input));
        HashSet<String> filenames = new HashSet<String>();
        String line = reader.readLine();
        while (line != null) {
            if (line.startsWith("F")) {
                filenames.add(line.replace("F", "").trim());
            }
            line = reader.readLine();
        }
        return filenames;
    }

    private Set<File> loadAllLdifFiles(Realm realm) throws IOException {
        Set<String> filenames = HTTPLdifImportAction.getAllFilenames();
        HashSet<File> files = new HashSet<File>();
        for (String name : filenames) {
            File file = this.loadLdifFile(name, realm);
            if (null == file) continue;
            files.add(file);
        }
        return files;
    }

    private File loadLdifFile(String filename, Realm realm) throws IOException {
        Object notify;
        int c;
        URL newURL = filename.endsWith(".ldif") ? new URL(baseURL + filename) : new URL(baseURL + filename + ".ldif");
        InputStream in = newURL.openStream();
        String input = "";
        while ((c = in.read()) != -1) {
            input = input + (char)c;
        }
        int hashsum = input.hashCode();
        if (!this.allowedToImport(filename, hashsum, realm)) {
            return null;
        }
        if (enableAsk && (notify = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)Messages.getString("HttpLdifImportAction.choose", filename, realm.getConnectionDescriptor().getBaseDN()), 0))) == NotifyDescriptor.NO_OPTION) {
            return null;
        }
        File tempFile = File.createTempFile("tmp", ".ldif");
        this.storeHashsums(filename, hashsum);
        input = input.replaceAll("#%BASEDN%#", LDAPDirectory.idToUpperCase((String)realm.getConnectionDescriptor().getBaseDN()));
        RandomAccessFile raf = new RandomAccessFile(tempFile, "rw");
        raf.writeBytes(input);
        return tempFile;
    }

    public void importAllLdifFolder(final String foldername, final Realm realm) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                block7: {
                    try {
                        if (foldername != null) {
                            HTTPLdifImportAction.this.makeNewBaseUrl(realm.getConnectionDescriptor().getHostname(), foldername);
                        }
                        if (HTTPLdifImportAction.this.checkAccess()) {
                            Set tempFiles = HTTPLdifImportAction.this.loadAllLdifFiles(realm);
                            if (tempFiles.size() <= 0) break block7;
                            try {
                                DirectoryEntryNode.importHTTPAction(realm.getConnectionDescriptor(), tempFiles);
                                HTTPLdifImportAction.this.setAllHashsums(realm);
                                break block7;
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                                return;
                            }
                        }
                        logger.warn((Object)("Can't use url: " + baseURL));
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    public void importAllLdifList(final Set<String> filenames, final Realm realm) throws IOException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (HTTPLdifImportAction.this.checkAccess()) {
                        HashSet<File> tempFiles = new HashSet<File>();
                        for (String name : filenames) {
                            tempFiles.add(HTTPLdifImportAction.this.loadLdifFile(name, realm));
                        }
                        if (tempFiles.size() > 0) {
                            DirectoryEntryNode.importHTTPAction(realm.getConnectionDescriptor(), tempFiles);
                            HTTPLdifImportAction.this.setAllHashsums(realm);
                        }
                    } else {
                        logger.warn((Object)("Can't use url: " + baseURL));
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void importOneFromURL(String filename, Realm realm) throws IOException {
        if (this.checkAccess()) {
            File importFile = this.loadLdifFile(filename, realm);
            if (importFile != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Import follwing file: " + filename + ".ldif"));
                }
                try {
                    LdifActionProgressBar bar = new LdifActionProgressBar();
                    bar.startProgress();
                    DirectoryEntryNode.importAction(realm.getConnectionDescriptor(), importFile, bar);
                    this.setAllHashsums(realm);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                importFile.delete();
            }
        } else {
            logger.warn((Object)("Can't use url: " + baseURL));
        }
    }

    private void setHashsum(String filename, int hashsum, Realm realm) {
        filename = filename.replace(".ldif", "").trim();
        String path = "invisibleObjects." + filename;
        Long value = new Long(hashsum);
        realm.setValue(path, value.toString());
        try {
            realm.getDirectory().save((Object)realm, "");
        }
        catch (DirectoryException e1) {
            e1.printStackTrace();
        }
    }

    private void storeHashsums(String filename, int hashsum) {
        this.allNewNames.add(filename);
        this.allHashs.put(filename, hashsum);
    }

    private void setAllHashsums(Realm realm) throws IOException {
        for (String name : this.allNewNames) {
            this.setHashsum(name, this.allHashs.get(name), realm);
        }
    }

    private boolean allowedToImport(String filename, int hashsum, Realm realm) {
        filename = filename.replace(".ldif", "").trim();
        Long hash = new Long(hashsum);
        String existingHash = realm.getValue("invisibleObjects." + filename);
        if (hash.toString().equals(existingHash)) {
            return false;
        }
        logger.info((Object)("Did not yet import " + filename + " - create new one and import LDIFs!!!"));
        return true;
    }

    public static boolean isEnableAsk() {
        return enableAsk;
    }

    public static void setEnableAsk(boolean enableAsk) {
        HTTPLdifImportAction.enableAsk = enableAsk;
    }

    static {
        enableAsk = true;
    }
}

