/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.configuration;

import java.net.URL;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.services.Dhcp;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

@Configuration
@ComponentScan(basePackages={"org.openthinclient.console"})
public class HttpInvokerConfiguration {
    @Autowired
    Environment environment;

    @Bean
    public URL managerCodeBaseURL() throws Exception {
        String serverName = this.environment.getProperty("manager.server.name");
        return new URL("http://" + serverName + ":8080");
    }

    @Bean
    @Lazy
    public FactoryBean<Object> packageManagerService() throws Exception {
        HttpInvokerProxyFactoryBean invokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();
        invokerProxyFactoryBean.setServiceInterface(PackageManager.class);
        invokerProxyFactoryBean.setServiceUrl(new URL(this.managerCodeBaseURL(), "/service/httpinvoker/package-manager").toExternalForm());
        return invokerProxyFactoryBean;
    }

    @Bean
    @Lazy
    public FactoryBean<Object> dhcpService() throws Exception {
        HttpInvokerProxyFactoryBean invokerProxyFactoryBean = new HttpInvokerProxyFactoryBean();
        invokerProxyFactoryBean.setServiceInterface(Dhcp.class);
        invokerProxyFactoryBean.setServiceUrl(new URL(this.managerCodeBaseURL(), "/service/httpinvoker/dhcp").toExternalForm());
        return invokerProxyFactoryBean;
    }
}

