/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.Validator;
import com.jgoodies.validation.util.PropertyValidationSupport;
import com.jgoodies.validation.util.ValidationUtils;
import java.awt.Component;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.ErrorManager;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Realm;
import org.openthinclient.console.Messages;
import org.openthinclient.console.nodes.views.UnrecognizedClientEditor;
import org.openthinclient.console.util.DetailViewFormBuilder;
import org.openthinclient.ldap.DirectoryException;

public class ClientEditor
extends JPanel {
    public ClientEditor(Client client, Realm realm) {
        HashSet hwtypes;
        HashSet locations;
        PresentationModel model = new PresentationModel((ValueModel)new ValueHolder((Object)client, true));
        DetailViewFormBuilder dfb = new DetailViewFormBuilder(new FormLayout("r:p, 3dlu, f:p:g"), Messages.getBundle(), this);
        dfb.getPanel().setName(Messages.getString("Settings_title"));
        dfb.appendI15d("Client.ipHostNumber", BasicComponentFactory.createTextField((ValueModel)model.getModel("ipHostNumber"), (boolean)true));
        dfb.nextLine();
        if (UnrecognizedClientEditor.isUnrecognize()) {
            JTextField macAdressTextField = BasicComponentFactory.createTextField((ValueModel)model.getModel("macAddress"));
            macAdressTextField.setEditable(false);
            dfb.appendI15d("Client.macAddress", (Component)macAdressTextField, false);
        } else {
            dfb.appendI15d("Client.macAddress", BasicComponentFactory.createTextField((ValueModel)model.getModel("macAddress"), (boolean)false));
        }
        dfb.nextLine();
        try {
            locations = realm.getDirectory().list(Location.class);
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            locations = new HashSet();
        }
        JComboBox locationBox = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList(new ArrayList(locations), (ValueModel)model.getModel("location")));
        dfb.appendI15d("Client.location", locationBox);
        if (locations.size() == 1 && locationBox.getSelectedIndex() < 0) {
            locationBox.setSelectedIndex(0);
        }
        dfb.nextLine();
        try {
            hwtypes = realm.getDirectory().list(HardwareType.class);
        }
        catch (DirectoryException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            hwtypes = new HashSet();
        }
        JComboBox hwtBox = BasicComponentFactory.createComboBox((SelectionInList)new SelectionInList(new ArrayList(hwtypes), (ValueModel)model.getModel("hardwareType")));
        dfb.appendI15d("Client.hardwareType", hwtBox);
        if (hwtypes.size() == 1 && hwtBox.getSelectedIndex() < 0) {
            hwtBox.setSelectedIndex(0);
        }
        dfb.nextLine();
        this.putClientProperty("validator", new ClientValidator(model, client));
    }

    private static class ClientValidator
    implements Validator {
        private final Client client;
        private static final Pattern MAC_ADDRESS_PATTERN = Pattern.compile("(\\p{XDigit}{2}:){5}\\p{XDigit}{2}");
        private final PresentationModel model;

        ClientValidator(PresentationModel model, Client client) {
            this.model = model;
            this.client = client;
        }

        public ValidationResult validate() {
            char[] chars;
            if (UnrecognizedClientEditor.isUnrecognize()) {
                this.client.setIpHostNumber(UnrecognizedClientEditor.getIpAddress());
                this.client.setMacAddress(UnrecognizedClientEditor.getMacAddress());
                UnrecognizedClientEditor.setUnrecognize(false);
            }
            this.model.triggerCommit();
            PropertyValidationSupport support = new PropertyValidationSupport((Object)this.client, "Client");
            support.addWarning("ipaddress", Messages.getString("ClientEditor.validation.ipaddress.forInformation"));
            if (null == this.client.getIpHostNumber() || this.client.getIpHostNumber().equals("")) {
                support.addError("IP Address", Messages.getString("ClientEditor.validation.ipaddress.mandatory"));
            }
            if (null == this.client.getLocation()) {
                support.addError("location", Messages.getString("ClientEditor.validation.location.mandatory"));
            }
            if (null == this.client.getHardwareType()) {
                support.addError("hwtype", Messages.getString("ClientEditor.validation.hwtype.mandatory"));
            }
            if (ValidationUtils.isEmpty((String)this.client.getMacAddress())) {
                support.addError("macaddress", Messages.getString("ClientEditor.validation.macaddress.mandatory"));
            } else if (!MAC_ADDRESS_PATTERN.matcher(this.client.getMacAddress()).matches()) {
                support.addError("macaddress", Messages.getString("ClientEditor.validation.macaddress.invalid"));
            }
            if (!ValidationUtils.isEmpty((String)this.client.getIpHostNumber())) {
                try {
                    InetAddress addr = InetAddress.getByName(this.client.getIpHostNumber());
                    if (addr.isLinkLocalAddress() || addr.isMulticastAddress()) {
                        support.addError("ipaddress", Messages.getString("ClientEditor.validation.ipaddress.islocal"));
                    } else if (addr.isLoopbackAddress()) {
                        support.addError("ipaddress", Messages.getString("ClientEditor.validation.ipaddress.isloopback"));
                    } else {
                        this.client.setIpHostNumber(addr.getHostAddress());
                    }
                }
                catch (UnknownHostException e) {
                    support.addWarning("ipaddress", Messages.getString("ClientEditor.validation.ipaddress.hostunknown"));
                }
                catch (NumberFormatException e) {
                    support.addError("ipaddress", Messages.getString("ClientEditor.validation.ipaddress.invalod"));
                }
            }
            if ((chars = this.client.getName().toCharArray()).length > 0) {
                if (!Character.isJavaIdentifierStart(chars[0])) {
                    support.addWarning("name", Messages.getString("DirObjectEditor.validation.name.discouraged"));
                } else {
                    for (char c : chars) {
                        if ((Character.isJavaIdentifierPart(c) || c == '-') && "_.$".indexOf(c) < 0) continue;
                        support.addWarning("name", Messages.getString("DirObjectEditor.validation.name.discouraged"));
                        break;
                    }
                }
            }
            return support.getResult();
        }
    }
}

