/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.console.nodes.views;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.text.MessageFormat;
import javax.swing.JPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.util.Utilities;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.UnrecognizedClient;
import org.openthinclient.console.Messages;
import org.openthinclient.console.wizards.newdirobject.NewDirObjectTreeWizardIterator;
import org.openthinclient.ldap.DirectoryException;

public class UnrecognizedClientEditor
extends JPanel {
    private static String ipAddress;
    private static String macAddress;
    private static boolean unrecognize;

    public UnrecognizedClientEditor(UnrecognizedClient unrecognizedClient, Realm realm) {
        unrecognize = true;
        Client newClient = new Client();
        newClient.setName("New " + newClient.getClass().getName());
        UnrecognizedClientEditor.setMacAddress(unrecognizedClient.getMacAddress());
        UnrecognizedClientEditor.setIpAddress(unrecognizedClient.getIpHostNumber());
        WizardDescriptor wd = new WizardDescriptor((WizardDescriptor.Iterator)new NewDirObjectTreeWizardIterator());
        wd.setTitleFormat(new MessageFormat("{0} ({1})"));
        wd.setTitle(Messages.getString("UnrecognizedClientEditor.create"));
        wd.putProperty("type", newClient.getClass());
        wd.putProperty("realm", (Object)realm);
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wd);
        dialog.setIconImage(Utilities.loadImage((String)"org/openthinclient/console/icon.png", (boolean)true));
        dialog.setPreferredSize(new Dimension(830, 600));
        dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        dialog.setLocation((screenSize.width - dialog.getWidth()) / 2, (screenSize.height - dialog.getHeight()) / 2);
        dialog.setVisible(true);
        dialog.toFront();
        if (wd.getValue() == WizardDescriptor.FINISH_OPTION) {
            DirectoryObject dirObject = (DirectoryObject)wd.getProperty("dirObject");
            try {
                realm.getDirectory().save((Object)dirObject);
            }
            catch (DirectoryException e2) {
                ErrorManager.getDefault().notify((Throwable)e2);
            }
            try {
                realm.getDirectory().delete((Object)unrecognizedClient);
            }
            catch (DirectoryException e1) {
                e1.printStackTrace();
            }
        }
        unrecognize = false;
    }

    public static String getIpAddress() {
        return ipAddress;
    }

    public static String getMacAddress() {
        return macAddress;
    }

    public static void setIpAddress(String ipAddress) {
        UnrecognizedClientEditor.ipAddress = ipAddress;
    }

    public static void setMacAddress(String macAddress) {
        UnrecognizedClientEditor.macAddress = macAddress;
    }

    public static boolean isUnrecognize() {
        return unrecognize;
    }

    public static void setUnrecognize(boolean unrecognize) {
        UnrecognizedClientEditor.unrecognize = unrecognize;
    }

    static {
        unrecognize = false;
    }
}

