/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.importer.impl;

import org.openthinclient.api.importer.impl.ImportModelMapper;
import org.openthinclient.api.importer.model.ImportableClient;
import org.openthinclient.api.importer.model.ImportableHardwareType;
import org.openthinclient.api.importer.model.ImportableLocation;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.api.rest.model.Device;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;

public class RestModelImporter {
    private final ImportModelMapper mapper;
    private final HardwareTypeService hardwareTypeService;
    private final ApplicationService applicationService;
    private final ClientService clientService;
    private final DeviceService deviceService;
    private final LocationService locationService;
    private final PrinterService printerService;

    public RestModelImporter(ImportModelMapper mapper, HardwareTypeService hardwareTypeService, ApplicationService applicationService, ClientService clientService, DeviceService deviceService, LocationService locationService, PrinterService printerService) {
        this.mapper = mapper;
        this.hardwareTypeService = hardwareTypeService;
        this.applicationService = applicationService;
        this.clientService = clientService;
        this.deviceService = deviceService;
        this.locationService = locationService;
        this.printerService = printerService;
    }

    public org.openthinclient.common.model.Device importDevice(Device importable) {
        org.openthinclient.common.model.Device device = this.mapper.fromImportable(importable);
        this.deviceService.save((DirectoryObject)device);
        return device;
    }

    public HardwareType importHardwareType(ImportableHardwareType importable) {
        HardwareType hardwareType = this.mapper.fromImportable(importable);
        this.hardwareTypeService.save((DirectoryObject)hardwareType);
        return hardwareType;
    }

    public Printer importPrinter(org.openthinclient.api.rest.model.Printer importable) {
        Printer printer = this.mapper.fromImportable(importable);
        this.printerService.save((DirectoryObject)printer);
        return printer;
    }

    public Location importLocation(ImportableLocation importable) {
        Location location = this.mapper.fromImportable(importable);
        this.locationService.save((DirectoryObject)location);
        return location;
    }

    public Application importApplication(org.openthinclient.api.rest.model.Application importable) {
        Application application = this.mapper.fromImportable(importable);
        this.applicationService.save((DirectoryObject)application);
        return application;
    }

    public Client importClient(ImportableClient importable) {
        Client client = this.mapper.fromImportable(importable);
        this.clientService.save((DirectoryObject)client);
        return client;
    }

    public Profile importProfileObject(AbstractProfileObject importable) {
        if (importable instanceof ImportableClient) {
            return this.importClient((ImportableClient)importable);
        }
        if (importable instanceof Device) {
            return this.importDevice((Device)importable);
        }
        if (importable instanceof org.openthinclient.api.rest.model.Application) {
            return this.importApplication((org.openthinclient.api.rest.model.Application)importable);
        }
        if (importable instanceof ImportableLocation) {
            return this.importLocation((ImportableLocation)importable);
        }
        if (importable instanceof org.openthinclient.api.rest.model.Printer) {
            return this.importPrinter((org.openthinclient.api.rest.model.Printer)importable);
        }
        if (importable instanceof ImportableHardwareType) {
            return this.importHardwareType((ImportableHardwareType)importable);
        }
        throw new IllegalArgumentException("The provided profile object " + importable + " is not supported");
    }
}

