/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.openthinclient.api.rest.impl.ModelMapper;
import org.openthinclient.common.model.Device;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.service.DeviceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/model/device"})
public class DeviceResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceResource.class);
    private final DeviceService service;
    private final ModelMapper mapper;

    public DeviceResource(DeviceService service) {
        this.service = service;
        this.mapper = new ModelMapper();
    }

    @GetMapping
    public List<String> getDevices() {
        return this.service.findAll().stream().map(DirectoryObject::getName).collect(Collectors.toList());
    }

    @GetMapping(value={"/{name}"})
    public org.openthinclient.api.rest.model.Device getDevice(@PathVariable(value="name") String name) {
        Device device = (Device)this.service.findByName(name);
        if (device == null) {
            return null;
        }
        return this.mapper.translate(device.getRealm(), device);
    }
}

