/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.distributions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.openthinclient.api.context.InstallContext;
import org.openthinclient.api.distributions.ImportItem;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.progress.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportableProfileProvider {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final URI baseURL;

    public ImportableProfileProvider(URI baseURL) {
        this.baseURL = baseURL;
        this.log.info("Initialize ImportableProfileProvider with baseURL " + baseURL);
    }

    public AbstractProfileObject access(InstallContext context, ImportItem item, ProgressReceiver progressReceiver) throws Exception {
        URI path = this.createTargetURI(item);
        this.log.info("Import profile from " + path);
        if (this.requiresHttpDownload(path)) {
            DownloadManager downloadManager = context.getDownloadManager();
            if (downloadManager == null) {
                throw new IllegalStateException("To access the " + item + " from " + path + " a download manager is required. No download manager is currently available");
            }
            return (AbstractProfileObject)downloadManager.download(path, in -> this.read(in, item), progressReceiver);
        }
        try (InputStream in2 = path.toURL().openStream();){
            AbstractProfileObject abstractProfileObject = this.read(in2, item);
            return abstractProfileObject;
        }
    }

    private AbstractProfileObject read(InputStream in, ImportItem item) throws IOException {
        ObjectMapper mapper = this.getMapper();
        return (AbstractProfileObject)mapper.readValue(in, item.getTargetType());
    }

    private ObjectMapper getMapper() {
        return new ObjectMapper();
    }

    public URI createTargetURI(ImportItem item) {
        return this.baseURL.resolve(item.getPath());
    }

    public boolean requiresHttpDownload(URI uri) {
        if (uri.getScheme() == null) {
            return false;
        }
        return uri.getScheme().equalsIgnoreCase("http") || uri.getScheme().equalsIgnoreCase("https");
    }
}

