/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.impl;

import java.util.List;
import java.util.stream.Collectors;
import org.openthinclient.api.importer.impl.ImportModelMapper;
import org.openthinclient.api.importer.impl.RestModelImporter;
import org.openthinclient.api.importer.model.ImportableHardwareType;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/model/hardware-type"})
public class HardwareTypeResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HardwareTypeResource.class);
    private final RestModelImporter importer;
    private final HardwareTypeService service;
    private final ImportModelMapper mapper;

    public HardwareTypeResource(RestModelImporter importer, HardwareTypeService service, ImportModelMapper mapper) {
        this.importer = importer;
        this.service = service;
        this.mapper = mapper;
    }

    @PostMapping
    public ResponseEntity<String> createHardwareType(@RequestBody ImportableHardwareType hardwareType) {
        try {
            this.importer.importHardwareType(hardwareType);
        }
        catch (Exception e) {
            LOGGER.error("Received illegal hardware type creation request", (Throwable)e);
            return ResponseEntity.badRequest().body((Object)e.getMessage());
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)"");
    }

    @GetMapping
    public List<String> getHardwareTypeNames() {
        return this.service.findAll().stream().map(DirectoryObject::getName).collect(Collectors.toList());
    }

    @GetMapping(value={"/{name}"})
    public ImportableHardwareType getHardwareType(@PathVariable(value="name") String name) {
        HardwareType hw = (HardwareType)this.service.findByName(name);
        if (hw == null) {
            return null;
        }
        return this.mapper.toImportable(hw);
    }
}

