/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.impl;

import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.api.rest.impl.ModelMapper;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.api.rest.model.Client;
import org.openthinclient.api.rest.model.Configuration;
import org.openthinclient.api.rest.model.Device;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/profiles/"}, method={RequestMethod.GET}, produces={"application/json"})
public class ProfileRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileRepository.class);
    private final ClientService clientService;
    private final UserService userService;
    private final HardwareTypeService hardwareTypeService;
    private final ModelMapper mapper;

    @Autowired
    public ProfileRepository(ClientService clientService, UserService userService, HardwareTypeService hardwareTypeService) {
        this.clientService = clientService;
        this.userService = userService;
        this.hardwareTypeService = hardwareTypeService;
        this.mapper = new ModelMapper();
    }

    @RequestMapping(value={"/clients/{hwAddress}"})
    public ResponseEntity<Client> getClient(@PathVariable(value="hwAddress") String hwAddress) {
        Optional<org.openthinclient.common.model.Client> optional = this.findClient(hwAddress);
        if (optional.isPresent()) {
            org.openthinclient.common.model.Client source = optional.get();
            Client client = this.mapper.translate(source.getRealm(), source);
            return ResponseEntity.ok((Object)this.resolveConfiguration(source.getRealm(), client));
        }
        return this.notFound();
    }

    private <T extends AbstractProfileObject> T resolveConfiguration(Realm realm, T profileObject) {
        String baseDN;
        String hostname = realm != null ? realm.getConnectionDescriptor().getHostname() : null;
        String string = baseDN = realm != null ? realm.getConnectionDescriptor().getBaseDN() : null;
        if (hostname == null || hostname.length() == 0) {
            LOGGER.warn("Hostname not found, this leads to inproper client-configuration.");
        }
        if (baseDN == null || baseDN.length() == 0) {
            LOGGER.warn("BaseDN not found, this leads to inproper client-configuration.");
        }
        if (profileObject instanceof Client) {
            Client client = (Client)profileObject;
            if (client.getHardwareType() != null) {
                this.mergeConfiguration(client, client.getHardwareType().getConfiguration());
                client.setHardwareType(null);
            }
            if (client.getLocation() != null) {
                this.mergeConfiguration(client, client.getLocation().getConfiguration());
                client.setLocation(null);
            }
        }
        if (hostname != null && (hostname.equals("localhost") || hostname.equals("127.0.0.1"))) {
            Optional<InetAddress> externalIp = this.determineExternalIp();
            if (externalIp.isPresent()) {
                hostname = externalIp.get().getHostAddress();
                LOGGER.info("Replaced ${myip}-value 'localhost' with '{}'", (Object)hostname);
            } else {
                LOGGER.error("Cannot obtain the host ip-address, using default: " + hostname);
            }
        }
        String host = hostname;
        Map<String, Object> additionalProperties = profileObject.getConfiguration().getAdditionalProperties();
        Set<Map.Entry<String, Object>> entries = additionalProperties.entrySet();
        entries.forEach(entry -> {
            if (entry.getValue() != null && entry.getValue().toString().contains("${myip}") && host != null) {
                entry.setValue(entry.getValue().toString().replaceAll("\\$\\{myip\\}", host));
            }
            if (entry.getValue() != null && entry.getValue().toString().contains("${urlencoded:basedn}") && baseDN != null) {
                try {
                    entry.setValue(entry.getValue().toString().replaceAll("\\$\\{urlencoded\\:basedn\\}", URLEncoder.encode(baseDN, "UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error("UTF-8 encoding not supported", (Throwable)e);
                }
            }
            if (entry.getValue() != null && entry.getValue().toString().contains("${basedn}") && baseDN != null) {
                entry.setValue(entry.getValue().toString().replaceAll("\\$\\{basedn\\}", baseDN));
            }
        });
        return profileObject;
    }

    private Optional<InetAddress> determineExternalIp() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress address = inetAddresses.nextElement();
                    if (address.isLinkLocalAddress() || address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                    return Optional.of(address);
                }
            }
        }
        catch (SocketException e) {
            LOGGER.error("Could not determine external IP-address " + e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    private void mergeConfiguration(Client client, Configuration conf) {
        Map<String, Object> clientProperties = client.getConfiguration().getAdditionalProperties();
        conf.getAdditionalProperties().forEach((key, value) -> {
            if (!clientProperties.containsKey(key)) {
                clientProperties.put((String)key, value);
            }
        });
    }

    private <T> ResponseEntity<T> notFound() {
        return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body(null);
    }

    private Optional<org.openthinclient.common.model.Client> findClient(String hwAddress) {
        hwAddress = hwAddress.toLowerCase();
        return this.clientService.findByHwAddress(hwAddress).stream().findFirst();
    }

    @RequestMapping(value={"/clients"})
    public ResponseEntity<List<Client>> getClients() {
        Stream<Client> clients = this.clientService.findAll().stream().map(source -> this.resolveConfiguration(source.getRealm(), this.mapper.translate(source.getRealm(), (org.openthinclient.common.model.Client)source)));
        return ResponseEntity.ok(clients.collect(Collectors.toList()));
    }

    @RequestMapping(value={"/clients/{hwAddress}/devices"})
    public ResponseEntity<List<Device>> getDevices(@PathVariable(value="hwAddress") String hwAddress) {
        Optional<org.openthinclient.common.model.Client> opt = this.findClient(hwAddress);
        if (!opt.isPresent()) {
            return this.notFound();
        }
        org.openthinclient.common.model.Client client = opt.get();
        List res = Stream.concat(client.getDevices().stream(), client.getHardwareType().getDevices().stream()).map(source -> this.mapper.translate(client.getRealm(), (org.openthinclient.common.model.Device)source)).collect(Collectors.toList());
        return ResponseEntity.ok(res);
    }

    @RequestMapping(value={"/clients/{hwAddress}/applications"})
    public ResponseEntity<List<org.openthinclient.api.rest.model.Application>> getApplications(@PathVariable(value="hwAddress") String hwAddress) {
        Optional<org.openthinclient.common.model.Client> opt = this.findClient(hwAddress);
        if (!opt.isPresent()) {
            return this.notFound();
        }
        org.openthinclient.common.model.Client client = opt.get();
        Stream localApplications = client.getApplications().stream();
        Realm realm = client.getRealm();
        List<org.openthinclient.api.rest.model.Application> res = localApplications.map(source -> this.mapper.translate(realm, (Application)source)).collect(Collectors.toList());
        for (ApplicationGroup applicationGroup : client.getApplicationGroups()) {
            this.addApplications(realm, applicationGroup, res);
        }
        return ResponseEntity.ok(res);
    }

    @RequestMapping(value={"/clients/{hwAddress}/printers"})
    public ResponseEntity<List<org.openthinclient.api.rest.model.Printer>> getPrinters(@PathVariable(value="hwAddress") String hwAddress) {
        Optional<org.openthinclient.common.model.Client> opt = this.findClient(hwAddress);
        if (!opt.isPresent()) {
            return this.notFound();
        }
        org.openthinclient.common.model.Client client = opt.get();
        Stream printers = Stream.concat(client.getPrinters().stream(), client.getLocation().getPrinters().stream());
        Realm realm = client.getRealm();
        List res = printers.map(source -> this.mapper.translate(realm, (Printer)source)).collect(Collectors.toList());
        return ResponseEntity.ok(res);
    }

    @RequestMapping(value={"/users/{sAMAccountName}/applications"})
    public ResponseEntity<List<org.openthinclient.api.rest.model.Application>> getApplicationByUser(@PathVariable(value="sAMAccountName") String sAMAccountName) {
        Optional opt = this.userService.findBySAMAccountName(sAMAccountName);
        if (!opt.isPresent()) {
            return this.notFound();
        }
        User user = (User)opt.get();
        Realm realm = user.getRealm();
        List res = Stream.concat(user.getApplications().stream(), Stream.concat(user.getUserGroups().stream().map(UserGroup::getApplications).flatMap(Collection::stream), Stream.concat(user.getApplicationGroups().stream().map(this::getApplications).flatMap(Collection::stream), user.getUserGroups().stream().map(UserGroup::getApplicationGroups).flatMap(Collection::stream).map(this::getApplications).flatMap(Collection::stream)))).map(source -> this.mapper.translate(realm, (Application)source)).collect(Collectors.toList());
        return ResponseEntity.ok(res);
    }

    @RequestMapping(value={"/users/{sAMAccountName}/printers"})
    public ResponseEntity<List<org.openthinclient.api.rest.model.Printer>> getPrinterByUser(@PathVariable(value="sAMAccountName") String sAMAccountName) {
        Optional opt = this.userService.findBySAMAccountName(sAMAccountName);
        if (!opt.isPresent()) {
            return this.notFound();
        }
        User user = (User)opt.get();
        Realm realm = user.getRealm();
        List res = Stream.concat(user.getPrinters().stream(), user.getUserGroups().stream().map(UserGroup::getPrinters).flatMap(Collection::stream)).map(source -> this.mapper.translate(realm, (Printer)source)).collect(Collectors.toList());
        return ResponseEntity.ok(res);
    }

    @GetMapping(value={"/hardware-type/{name}"})
    public ResponseEntity<org.openthinclient.api.rest.model.HardwareType> getHardwareType(@PathVariable(value="name") String name) {
        HardwareType hw = (HardwareType)this.hardwareTypeService.findByName(name);
        if (hw == null) {
            return this.notFound();
        }
        hw.initSchemas(hw.getRealm());
        org.openthinclient.api.rest.model.HardwareType hardwareType = this.mapper.translate(hw.getRealm(), hw);
        return ResponseEntity.ok((Object)this.resolveConfiguration(hw.getRealm(), hardwareType));
    }

    private Set<Application> getApplications(ApplicationGroup applicationGroup) {
        Set applications = applicationGroup.getApplications();
        applicationGroup.getApplicationGroups().forEach(ag -> applications.addAll(this.getApplications((ApplicationGroup)ag)));
        return applications;
    }

    private void addApplications(Realm realm, ApplicationGroup applicationGroup, List<org.openthinclient.api.rest.model.Application> res) {
        for (Application source : applicationGroup.getApplications()) {
            org.openthinclient.api.rest.model.Application application = this.mapper.translate(realm, source);
            if (application == null) continue;
            res.add(application);
        }
        for (ApplicationGroup group : applicationGroup.getApplicationGroups()) {
            this.addApplications(realm, group, res);
        }
    }
}

