/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.importer.impl;

import com.google.common.base.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.mapstruct.TargetType;
import org.openthinclient.api.importer.impl.ImportException;
import org.openthinclient.api.importer.impl.MissingReferencedObjectException;
import org.openthinclient.api.importer.model.ProfileReference;
import org.openthinclient.api.importer.model.ProfileType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.DeviceService;
import org.openthinclient.common.model.service.HardwareTypeService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.springframework.beans.factory.annotation.Autowired;

public class ProfileReferenceResolver {
    private final HardwareTypeService hardwareTypeService;
    private final ApplicationService applicationService;
    private final ClientService clientService;
    private final DeviceService deviceService;
    private final LocationService locationService;
    private final PrinterService printerService;

    @Autowired
    public ProfileReferenceResolver(HardwareTypeService hardwareTypeService, ApplicationService applicationService, ClientService clientService, DeviceService deviceService, LocationService locationService, PrinterService printerService) {
        this.hardwareTypeService = hardwareTypeService;
        this.applicationService = applicationService;
        this.clientService = clientService;
        this.deviceService = deviceService;
        this.locationService = locationService;
        this.printerService = printerService;
    }

    public <T extends Profile> T resolve(ProfileReference reference, @TargetType Class<T> profileType) {
        Enum expected = null;
        for (ProfileType cur : ProfileType.values()) {
            if (!Objects.equal(cur.getTargetType(), profileType)) continue;
            expected = cur;
            break;
        }
        if (expected == null) {
            throw new IllegalArgumentException("Unsupported type of profile: " + profileType);
        }
        this.validateReference((ProfileType)expected, reference);
        switch (1.$SwitchMap$org$openthinclient$api$importer$model$ProfileType[expected.ordinal()]) {
            case 1: {
                return (T)this.resolveReferences(reference, arg_0 -> ((ApplicationService)this.applicationService).findByName(arg_0));
            }
            case 2: {
                return (T)this.resolveReferences(reference, arg_0 -> ((HardwareTypeService)this.hardwareTypeService).findByName(arg_0));
            }
            case 3: {
                return (T)this.resolveReferences(reference, arg_0 -> ((DeviceService)this.deviceService).findByName(arg_0));
            }
            case 4: {
                Optional<Location> first = this.locationService.findAll().stream().filter(location -> location.getName().equals(reference.getName())).findFirst();
                if (first.isPresent()) {
                    return (T)((Profile)first.get());
                }
                throw new MissingReferencedObjectException(reference);
            }
            case 5: {
                return (T)this.resolveReferences(reference, arg_0 -> ((ClientService)this.clientService).findByName(arg_0));
            }
            case 6: {
                return (T)this.resolveReferences(reference, arg_0 -> ((PrinterService)this.printerService).findByName(arg_0));
            }
        }
        throw new IllegalArgumentException("Failed to process reference. Unknown profile type: " + profileType);
    }

    private <T extends Profile> T resolveReferences(ProfileReference ref, Function<String, T> lookup) {
        Profile target = (Profile)lookup.apply(ref.getName());
        if (target == null) {
            throw new MissingReferencedObjectException(ref);
        }
        return (T)target;
    }

    private void validateReference(ProfileType type, ProfileReference ref) {
        if (!Objects.equal((Object)((Object)type), (Object)((Object)ref.getType()))) {
            throw new ImportException("Illegal reference: '" + ref.getCompactRepresentation() + "' refers to type " + (Object)((Object)ref.getType()) + " but must refer to " + (Object)((Object)type));
        }
    }
}

