/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.impl;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import java.util.Locale;
import java.util.stream.Stream;
import org.openthinclient.api.i18n.RestMessages;
import org.openthinclient.api.rest.model.License;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/licensing"})
public class LicenseResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseResource.class);
    private final ClientService clientService;
    private final LicenseManager licenseManager;
    private IMessageConveyor mcEN = new MessageConveyor(Locale.ENGLISH);
    private IMessageConveyor mcDE = new MessageConveyor(Locale.GERMAN);

    public LicenseResource(ClientService clientService, LicenseManager licenseManager) {
        this.clientService = clientService;
        this.licenseManager = licenseManager;
    }

    @GetMapping
    public License getLicense() {
        int clients = this.clientService.count();
        License.State licenseState = this.licenseManager.getLicenseState(clients);
        if (licenseState == null) {
            return new License();
        }
        switch (licenseState) {
            case REQUIRED_TOO_OLD: {
                return new License(3, this.getMessages(RestMessages.REST_LICENSE_THINCLIENT_COMMUNICATION_ERROR));
            }
            case REQUIRED_EXPIRED: {
                return new License(3, this.getMessages(RestMessages.REST_LICENSE_THINCLIENT_LICENSE_EXPIRED));
            }
            case TOO_MANY: {
                return new License(3, this.getMessages(RestMessages.REST_LICENSE_THINCLIENT_TOO_MANY));
            }
            case INVALID: {
                return new License(3, this.getMessages(RestMessages.REST_LICENSE_THINCLIENT_CRITICAL_ERROR));
            }
            case REQUIRED_MISSING: {
                return new License(3, this.getMessages(RestMessages.REST_LICENSE_THINCLIENT_BUY_LICENSE));
            }
        }
        return new License();
    }

    private String[] getMessages(RestMessages key) {
        return (String[])Stream.of(this.mcDE.getMessage((Enum)key, new Object[0]), this.mcEN.getMessage((Enum)key, new Object[0])).toArray(String[]::new);
    }
}

